/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.BPMNDiagramMarshallerBaseTest;
import org.kie.workbench.common.stunner.bpmn.definition.Lane;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet;
import org.kie.workbench.common.stunner.core.definition.service.DiagramMarshaller;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;

public class LaneTest
extends BPMNDiagramMarshallerBaseTest {
    private static final String BPMN_LANE_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/lanesProcess.bpmn";
    private static final String EMPTY_LANE_ID = "_F6EBDAC4-127E-4626-93DC-234EDCEF6353";
    private static final String FILLED_LANE_ID = "_326DD976-52C1-4782-A738-D95A43A0E395";
    private static final String LANE_WITH_NODES_ID = "_9B3559C9-83AE-48E4-98D6-8C03E9116B34";
    private static final int AMOUNT_OF_NODES_IN_DIAGRAM = 7;
    private static final String EMPTY_VALUE = "";

    @Before
    public void setUp() {
        super.init();
    }

    @Test
    public void testMarshallLaneFilledProperties() throws Exception {
        this.checkLaneMarshalling(FILLED_LANE_ID, new String[0]);
    }

    @Test
    public void testMarshallLaneEmptyProperties() throws Exception {
        this.checkLaneMarshalling(EMPTY_LANE_ID, new String[0]);
    }

    @Test
    public void testMarshallLaneWithNodes() throws Exception {
        String START_EVENT_INSIDE_LANE_ID = "_46E9A1B3-A54F-4BA9-A98F-E5869E49C51E";
        String TASK_INSIDE_LANE_ID = "_58A4AAD8-EB1E-4729-B36F-2089B853E600";
        String END_EVENT_INSIDE_LANE_ID = "_95807837-C856-4A92-85D6-9EAFCB28B416";
        this.checkLaneMarshalling(LANE_WITH_NODES_ID, "_46E9A1B3-A54F-4BA9-A98F-E5869E49C51E", "_58A4AAD8-EB1E-4729-B36F-2089B853E600", "_95807837-C856-4A92-85D6-9EAFCB28B416");
    }

    @Test
    public void testUnmarshallLaneFilledProperties() throws Exception {
        String EVENT_NAME = "Lane name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "Lane doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_LANE_FILE_PATH);
        this.assertDiagram(diagram, 7);
        Lane filledLane = this.getLaneNodeById(diagram, FILLED_LANE_ID);
        this.assertGeneralSet(filledLane.getGeneral(), "Lane name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Lane doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertLaneSubNodes(diagram, FILLED_LANE_ID, new String[0]);
    }

    @Test
    public void testUnmarshallLaneEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_LANE_FILE_PATH);
        this.assertDiagram(diagram, 7);
        Lane emptyLane = this.getLaneNodeById(diagram, EMPTY_LANE_ID);
        this.assertGeneralSet(emptyLane.getGeneral(), EMPTY_VALUE, EMPTY_VALUE);
        this.assertLaneSubNodes(diagram, EMPTY_LANE_ID, new String[0]);
    }

    @Test
    public void testUnmarshallLaneWithNodes() throws Exception {
        String EVENT_NAME = "Lane";
        String START_EVENT_INSIDE_LANE_ID = "_46E9A1B3-A54F-4BA9-A98F-E5869E49C51E";
        String TASK_INSIDE_LANE_ID = "_58A4AAD8-EB1E-4729-B36F-2089B853E600";
        String END_EVENT_INSIDE_LANE_ID = "_95807837-C856-4A92-85D6-9EAFCB28B416";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_LANE_FILE_PATH);
        this.assertDiagram(diagram, 7);
        Lane laneWithNodes = this.getLaneNodeById(diagram, LANE_WITH_NODES_ID);
        this.assertGeneralSet(laneWithNodes.getGeneral(), "Lane", EMPTY_VALUE);
        this.assertLaneSubNodes(diagram, LANE_WITH_NODES_ID, "_46E9A1B3-A54F-4BA9-A98F-E5869E49C51E", "_58A4AAD8-EB1E-4729-B36F-2089B853E600", "_95807837-C856-4A92-85D6-9EAFCB28B416");
    }

    private void assertNodesEqualsAfterMarshalling(Diagram<Graph, Metadata> before, Diagram<Graph, Metadata> after, String nodeId) {
        Lane nodeBeforeMarshalling = this.getLaneNodeById(before, nodeId);
        Lane nodeAfterMarshalling = this.getLaneNodeById(after, nodeId);
        Assertions.assertThat((Object)nodeAfterMarshalling).isEqualTo((Object)nodeBeforeMarshalling);
    }

    private Lane getLaneNodeById(Diagram<Graph, Metadata> diagram, String id) {
        Node<? extends Definition, ?> node = this.getNodebyId(diagram, id);
        return (Lane)((Definition)node.getContent()).getDefinition();
    }

    private Node<? extends Definition, ?> getNodebyId(Diagram<Graph, Metadata> diagram, String id) {
        Node node = diagram.getGraph().getNode(id);
        Assertions.assertThat((Object)node).isNotNull();
        return node;
    }

    private void checkLaneMarshalling(String nodeID, String ... nodesInsideLane) throws Exception {
        Diagram<Graph, Metadata> initialDiagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_LANE_FILE_PATH);
        int AMOUNT_OF_NODES_IN_DIAGRAM = this.getNodes(initialDiagram).size();
        String resultXml = this.marshaller.marshall(initialDiagram);
        Diagram<Graph, Metadata> marshalledDiagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, this.getStream(resultXml));
        this.assertDiagram(marshalledDiagram, AMOUNT_OF_NODES_IN_DIAGRAM);
        this.assertNodesEqualsAfterMarshalling(initialDiagram, marshalledDiagram, nodeID);
        this.assertLaneSubNodes(marshalledDiagram, nodeID, nodesInsideLane);
    }

    private void assertGeneralSet(BPMNGeneralSet generalSet, String nodeName, String documentation) {
        Assertions.assertThat((Object)generalSet).isNotNull();
        Assertions.assertThat((Object)generalSet.getName()).isNotNull();
        Assertions.assertThat((Object)generalSet.getDocumentation()).isNotNull();
        Assertions.assertThat((String)generalSet.getName().getValue()).isEqualTo(nodeName);
        Assertions.assertThat((String)generalSet.getDocumentation().getValue()).isEqualTo(documentation);
    }

    private void assertLaneSubNodes(Diagram<Graph, Metadata> diagram, String laneId, String ... nodesInsideLane) {
        Node<? extends Definition, ?> node = this.getNodebyId(diagram, laneId);
        Assertions.assertThat((List)node.getInEdges()).hasSize(1);
        Assertions.assertThat((List)node.getOutEdges()).hasSize(nodesInsideLane.length);
        ArrayList<String> subNodesUUIDs = new ArrayList<String>();
        for (Edge item : node.getOutEdges()) {
            Assertions.assertThat((Object)item).isNotNull();
            Assertions.assertThat((Object)item.getSourceNode()).isNotNull();
            Assertions.assertThat((Object)item.getTargetNode()).isNotNull();
            Assertions.assertThat((String)item.getSourceNode().getUUID()).isEqualTo(laneId);
            subNodesUUIDs.add(item.getTargetNode().getUUID());
        }
        Assertions.assertThat(subNodesUUIDs).containsExactlyInAnyOrder((Object[])nodesInsideLane);
    }
}

