/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events;

import java.io.StringReader;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.EndEventTest;
import org.kie.workbench.common.stunner.bpmn.definition.EndMessageEvent;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.message.MessageEventExecutionSet;
import org.kie.workbench.common.stunner.core.definition.service.DiagramMarshaller;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class EndMessageEventTest
extends EndEventTest<EndMessageEvent> {
    private static final String BPMN_END_EVENT_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/endMessageEvents.bpmn";
    private static final String EMPTY_TOP_LEVEL_EVENT_ID = "_C16E011F-1891-48C9-8619-2FEF678DEA39";
    private static final String FILLED_TOP_LEVEL_EVENT_ID = "_86928E1F-5B98-43F3-AF00-FF92A2D8C19C";
    private static final String EMPTY_SUBPROCESS_LEVEL_EVENT_ID = "_1A5F9123-053C-46D7-BBC9-BBB5AB794609";
    private static final String FILLED_SUBPROCESS_LEVEL_EVENT_ID = "_8FD9C393-5605-4451-B8F6-EB5E79BC9922";
    private static final String EMPTY_WITH_INCOME_TOP_LEVEL_EVENT_ID = "_97C6413B-F73E-4D41-8AA8-D23F30691B27";
    private static final String FILLED_WITH_INCOME_TOP_LEVEL_EVENT_ID = "_DC2F1675-18E8-4918-9B61-8D8AD26799C0";
    private static final String EMPTY_WITH_INCOME_SUBPROCESS_LEVEL_EVENT_ID = "_D4D69CB0-46B6-47DA-AFB2-DF4A0AEFECA2";
    private static final String FILLED_WITH_INCOME_SUBPROCESS_LEVEL_EVENT_ID = "_6131912B-1ED5-454F-ACB4-EC623EE0C3A3";
    private static final int AMOUNT_OF_NODES_IN_DIAGRAM = 14;

    @Override
    @Test
    public void testUnmarshallTopLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "end event01 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "end event01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF = "message01";
        String MESSAGE_TYPE = "String";
        String EVENT_DATA_OUTPUT = "message01:String||||[din]processGlobalVar->message01";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_END_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 14);
        EndMessageEvent filledTopEvent = (EndMessageEvent)this.getEndNodeById(diagram, FILLED_TOP_LEVEL_EVENT_ID, false);
        this.assertGeneralSet(filledTopEvent.getGeneral(), "end event01 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "end event01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertMessageEventExecutionSet(filledTopEvent.getExecutionSet(), "message01", "String");
        this.assertDataIOSet(filledTopEvent.getDataIOSet(), "message01:String||||[din]processGlobalVar->message01");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEmptyEventProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_END_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 14);
        EndMessageEvent emptyTopEvent = (EndMessageEvent)this.getEndNodeById(diagram, EMPTY_TOP_LEVEL_EVENT_ID, false);
        this.assertGeneralSet(emptyTopEvent.getGeneral(), "", "");
        this.assertMessageEventExecutionSet(emptyTopEvent.getExecutionSet(), "", "");
        this.assertDataIOSet(emptyTopEvent.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "end event03 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "end event03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF = "message03";
        String MESSAGE_TYPE = "String";
        String EVENT_DATA_OUTPUT = "message03:String||||[din]processGlobalVar->message03";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_END_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 14);
        EndMessageEvent filledSubprocessEvent = (EndMessageEvent)this.getEndNodeById(diagram, FILLED_SUBPROCESS_LEVEL_EVENT_ID, false);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "end event03 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "end event03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertMessageEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "message03", "String");
        this.assertDataIOSet(filledSubprocessEvent.getDataIOSet(), "message03:String||||[din]processGlobalVar->message03");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_END_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 14);
        EndMessageEvent emptySubprocessEvent = (EndMessageEvent)this.getEndNodeById(diagram, EMPTY_SUBPROCESS_LEVEL_EVENT_ID, false);
        this.assertGeneralSet(emptySubprocessEvent.getGeneral(), "", "");
        this.assertMessageEventExecutionSet(emptySubprocessEvent.getExecutionSet(), "", "");
        this.assertDataIOSet(emptySubprocessEvent.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEventWithIncomeFilledProperties() throws Exception {
        String EVENT_NAME = "end event02 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "end event02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF = "message02";
        String MESSAGE_TYPE = "String";
        String EVENT_DATA_OUTPUT = "message02:String||||[din]processGlobalVar->message02";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_END_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 14);
        EndMessageEvent filledSubprocessEvent = (EndMessageEvent)this.getEndNodeById(diagram, FILLED_WITH_INCOME_TOP_LEVEL_EVENT_ID, true);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "end event02 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "end event02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertMessageEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "message02", "String");
        this.assertDataIOSet(filledSubprocessEvent.getDataIOSet(), "message02:String||||[din]processGlobalVar->message02");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEventWithIncomeEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_END_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 14);
        EndMessageEvent emptyEvent = (EndMessageEvent)this.getEndNodeById(diagram, EMPTY_WITH_INCOME_TOP_LEVEL_EVENT_ID, true);
        this.assertGeneralSet(emptyEvent.getGeneral(), "", "");
        this.assertMessageEventExecutionSet(emptyEvent.getExecutionSet(), "", "");
        this.assertDataIOSet(emptyEvent.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventWithIncomeEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_END_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 14);
        EndMessageEvent emptySubprocessEvent = (EndMessageEvent)this.getEndNodeById(diagram, EMPTY_WITH_INCOME_SUBPROCESS_LEVEL_EVENT_ID, true);
        this.assertGeneralSet(emptySubprocessEvent.getGeneral(), "", "");
        this.assertMessageEventExecutionSet(emptySubprocessEvent.getExecutionSet(), "", "");
        this.assertDataIOSet(emptySubprocessEvent.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventWithIncomeFilledProperties() throws Exception {
        String EVENT_NAME = "end event04 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "end event04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF = "message04";
        String MESSAGE_TYPE = "String";
        String EVENT_DATA_OUTPUT = "message04:String||||[din]processGlobalVar->message04";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_END_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 14);
        EndMessageEvent filledSubprocessEvent = (EndMessageEvent)this.getEndNodeById(diagram, FILLED_WITH_INCOME_SUBPROCESS_LEVEL_EVENT_ID, true);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "end event04 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "end event04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertMessageEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "message04", "String");
        this.assertDataIOSet(filledSubprocessEvent.getDataIOSet(), "message04:String||||[din]processGlobalVar->message04");
    }

    @Test
    public void testMarshallItemDefinitionOrder() throws Exception {
        Diagram<Graph, Metadata> initialDiagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, this.getBpmnEndEventFilePath());
        String resultXml = this.marshaller.marshall(initialDiagram);
        XMLReader xr = XMLReaderFactory.createXMLReader();
        xr.setContentHandler(new DefaultHandler(){
            int itemDefinitions = 0;
            int messages = 0;

            @Override
            public void startElement(String s, String s1, String s2, Attributes attributes) {
                if ("itemDefinition".equals(s1)) {
                    ++this.itemDefinitions;
                } else if ("message".equals(s1)) {
                    ++this.messages;
                    if (this.messages > 0 && this.itemDefinitions == 0) {
                        throw new IllegalArgumentException("Messages have been declared before itemDefinitions!");
                    }
                }
            }
        });
        Assertions.assertThatCode(() -> xr.parse(new InputSource(new StringReader(resultXml)))).doesNotThrowAnyException();
    }

    @Override
    String getBpmnEndEventFilePath() {
        return BPMN_END_EVENT_FILE_PATH;
    }

    @Override
    Class<EndMessageEvent> getEndEventType() {
        return EndMessageEvent.class;
    }

    @Override
    String getFilledTopLevelEventId() {
        return FILLED_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptyTopLevelEventId() {
        return EMPTY_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getFilledSubprocessLevelEventId() {
        return FILLED_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptySubprocessLevelEventId() {
        return EMPTY_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String getFilledTopLevelEventWithIncomeId() {
        return FILLED_WITH_INCOME_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptyTopLevelEventWithIncomeId() {
        return EMPTY_WITH_INCOME_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getFilledSubprocessLevelEventWithIncomeId() {
        return FILLED_WITH_INCOME_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptySubprocessLevelEventWithIncomeId() {
        return EMPTY_WITH_INCOME_SUBPROCESS_LEVEL_EVENT_ID;
    }

    private void assertMessageEventExecutionSet(MessageEventExecutionSet executionSet, String messageReferenceName, String messageReferenceType) {
        Assertions.assertThat((Object)executionSet).isNotNull();
        Assertions.assertThat((Object)executionSet.getMessageRef()).isNotNull();
        Assertions.assertThat((String)executionSet.getMessageRef().getValue()).isEqualTo(messageReferenceName);
        Assertions.assertThat((String)executionSet.getMessageRef().getStructure()).isEqualTo(messageReferenceType);
    }
}

