/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.subprocesses;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.subprocesses.SubProcessTest;
import org.kie.workbench.common.stunner.bpmn.definition.ReusableSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.DataIOSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.BaseReusableSubprocessTaskExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.ScriptTypeValue;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;

public class ReusableSubProcessTest
extends SubProcessTest<ReusableSubprocess> {
    private static final String BPMN_SUB_PROCESS_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/reusableSubProcesses.bpmn";
    private static final String TOP_LEVEL_EMPTY_SUBPROCESS_ID = "_83336319-6615-4FCC-B2EF-3376CB552CA9";
    private static final String TOP_LEVEL_FILLED_SUBPROCESS_JAVA_ID = "_B26D5827-370D-40F4-A92E-0D7F36E56BFD";
    private static final String TOP_LEVEL_FILLED_SUBPROCESS_JAVASCRIPT_ID = "_0E89076D-A208-44DC-A7EF-9BF03B0A2886";
    private static final String TOP_LEVEL_FILLED_SUBPROCESS_MVEL_ID = "_56591DB6-79A6-4D9E-94DE-B52EC3825F9A";
    private static final String SUBPROCESS_LEVEL_EMPTY_SUBPROCESS_ID = "_0C801E16-60D9-4F68-BE7F-1C296DEC9B3A";
    private static final String SUBPROCESS_LEVEL_FILLED_SUBPROCESS_JAVA_ID = "_335A3BD6-BFC0-4D77-A9CC-BA2F15CE4D53";
    private static final String SUBPROCESS_LEVEL_FILLED_SUBPROCESS_JAVASCRIPT_ID = "_9AF1C895-A124-4646-9061-FA8802DFDE97";
    private static final String SUBPROCESS_LEVEL_FILLED_SUBPROCESS_MVEL_ID = "_B4DED88D-9214-4690-8199-063EB688D7B6";
    private static final String TOP_LEVEL_SUBPROCESS_WITH_EDGES = "_BEBE4D01-648F-4DC5-8ED5-72D2F61F63D3";
    private static final String SUBPROCESS_LEVEL_SUBPROCESS_WITH_EDGES = "_362B7975-3E50-4B53-B351-C9D8C62B0C96";
    private static final int AMOUNT_OF_NODES_IN_DIAGRAM = 18;
    private static final String DEFAULT_CALLED_ELEMENT = "";
    private static final String DEFAULT_SUB_PROCESS_DATA_INPUT_OUTPUT = "||||";
    private static final boolean IS_INDEPENDENT = true;
    private static final boolean WAIT_FOR_COMPLETION = true;
    private static final boolean IS_NOT_INDEPENDENT = false;
    private static final boolean DO_NOT_WAIT_FOR_COMPLETION = false;
    private static final String TASK_SCRIPT_JAVA_LANGUAGE = "java";
    private static final String TASK_ON_ENTRY_ACTION_JAVA = "System.out.println(\"On Entry Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");";
    private static final String TASK_ON_EXIT_ACTION_JAVA = "System.out.println(\"On Exit Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");";
    private static final String TASK_SCRIPT_JAVASCRIPT_LANGUAGE = "javascript";
    private static final String TASK_ON_ENTRY_ACTION_JAVASCRIPT = "console.log(\"On Entry Action\");\nprint(\"~``!@#$%^&*()_+=-{}|\\n\\r][:\\\",.?\");\nprint(\"somevalue\" + \"~``!@#$%^&*()_+=-{}|\\n\\r][:\\\",.?\");";
    private static final String TASK_ON_EXIT_ACTION_JAVASCRIPT = "console.log(\"On Exit Action\");\nprint(\"~``!@#$%^&*()_+=-{}|\\n\\r][:\\\",.?\");\nprint(\"somevalue\" + \"~``!@#$%^&*()_+=-{}|\\n\\r][:\\\",.?\");";
    private static final String TASK_SCRIPT_MVEL_LANGUAGE = "mvel";
    private static final String TASK_ON_ENTRY_ACTION_MVEL = "System.out.println(\"On Entry Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");";
    private static final String TASK_ON_EXIT_ACTION_MVEL = "System.out.println(\"On Exit Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");";
    private static final String SLA_DUE_DATE = "12/25/1983";

    @Override
    @Test
    public void testUnmarshallTopLevelEmptyPropertiesSubProcess() {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 18);
        ReusableSubprocess topLevelSubProcess = (ReusableSubprocess)this.getSubProcessNodeById(diagram, TOP_LEVEL_EMPTY_SUBPROCESS_ID, 1, 0);
        this.assertGeneralSet(topLevelSubProcess.getGeneral(), DEFAULT_CALLED_ELEMENT, DEFAULT_CALLED_ELEMENT);
        this.assertReusableSubProcessExecutionSet((BaseReusableSubprocessTaskExecutionSet)topLevelSubProcess.getExecutionSet(), DEFAULT_CALLED_ELEMENT, false, false, false, DEFAULT_CALLED_ELEMENT, TASK_SCRIPT_JAVA_LANGUAGE, DEFAULT_CALLED_ELEMENT, TASK_SCRIPT_JAVA_LANGUAGE, DEFAULT_CALLED_ELEMENT);
        this.assertDataIOSet(topLevelSubProcess.getDataIOSet(), DEFAULT_SUB_PROCESS_DATA_INPUT_OUTPUT);
    }

    @Override
    @Test
    public void testUnmarshallTopLevelFilledPropertiesSubProcess() {
        String SUB_PROCESS_NAME = "Reusable process01 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String SUB_PROCESS_DOCUMENTATION = "Reusable process01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String CALLED_ELEMENT = "testProject.linkedReusableSubProcess";
        String SUB_PROCESS_DATA_INPUT_OUTPUT = "|input:String||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 18);
        ReusableSubprocess topLevelSubProcessJava = (ReusableSubprocess)this.getSubProcessNodeById(diagram, TOP_LEVEL_FILLED_SUBPROCESS_JAVA_ID, 1, 0);
        this.assertGeneralSet(topLevelSubProcessJava.getGeneral(), "Reusable process01 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Reusable process01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertReusableSubProcessExecutionSet((BaseReusableSubprocessTaskExecutionSet)topLevelSubProcessJava.getExecutionSet(), "testProject.linkedReusableSubProcess", true, true, true, "System.out.println(\"On Entry Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");", TASK_SCRIPT_JAVA_LANGUAGE, "System.out.println(\"On Exit Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");", TASK_SCRIPT_JAVA_LANGUAGE, SLA_DUE_DATE);
        this.assertDataIOSet(topLevelSubProcessJava.getDataIOSet(), "|input:String||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar");
        ReusableSubprocess topLevelSubProcessJavascript = (ReusableSubprocess)this.getSubProcessNodeById(diagram, TOP_LEVEL_FILLED_SUBPROCESS_JAVASCRIPT_ID, 1, 0);
        this.assertGeneralSet(topLevelSubProcessJavascript.getGeneral(), "Reusable process01 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Reusable process01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertReusableSubProcessExecutionSet((BaseReusableSubprocessTaskExecutionSet)topLevelSubProcessJavascript.getExecutionSet(), "testProject.linkedReusableSubProcess", true, true, true, TASK_ON_ENTRY_ACTION_JAVASCRIPT, TASK_SCRIPT_JAVASCRIPT_LANGUAGE, TASK_ON_EXIT_ACTION_JAVASCRIPT, TASK_SCRIPT_JAVASCRIPT_LANGUAGE, SLA_DUE_DATE);
        this.assertDataIOSet(topLevelSubProcessJavascript.getDataIOSet(), "|input:String||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar");
        ReusableSubprocess topLevelSubProcessMVEL = (ReusableSubprocess)this.getSubProcessNodeById(diagram, TOP_LEVEL_FILLED_SUBPROCESS_MVEL_ID, 1, 0);
        this.assertGeneralSet(topLevelSubProcessMVEL.getGeneral(), "Reusable process01 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Reusable process01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertReusableSubProcessExecutionSet((BaseReusableSubprocessTaskExecutionSet)topLevelSubProcessMVEL.getExecutionSet(), "testProject.linkedReusableSubProcess", true, true, true, "System.out.println(\"On Entry Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");", TASK_SCRIPT_MVEL_LANGUAGE, "System.out.println(\"On Exit Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");", TASK_SCRIPT_MVEL_LANGUAGE, SLA_DUE_DATE);
        this.assertDataIOSet(topLevelSubProcessMVEL.getDataIOSet(), "|input:String||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelSubProcessWithEdges() {
        String SUB_PROCESS_NAME = "Sub-process";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 18);
        ReusableSubprocess topLevelSubProcessJava = (ReusableSubprocess)this.getSubProcessNodeById(diagram, TOP_LEVEL_SUBPROCESS_WITH_EDGES, 2, 2);
        this.assertGeneralSet(topLevelSubProcessJava.getGeneral(), "Sub-process", DEFAULT_CALLED_ELEMENT);
        this.assertReusableSubProcessExecutionSet((BaseReusableSubprocessTaskExecutionSet)topLevelSubProcessJava.getExecutionSet(), DEFAULT_CALLED_ELEMENT, false, false, true, "System.out.println(\"On Entry Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");", TASK_SCRIPT_JAVA_LANGUAGE, "System.out.println(\"On Exit Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");", TASK_SCRIPT_JAVA_LANGUAGE, DEFAULT_CALLED_ELEMENT);
        this.assertDataIOSet(topLevelSubProcessJava.getDataIOSet(), DEFAULT_SUB_PROCESS_DATA_INPUT_OUTPUT);
    }

    @Override
    @Test
    public void testUnmarshallSubProcessLevelEmptyPropertiesSubProcess() {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 18);
        ReusableSubprocess subProcessLevelSubProcess = (ReusableSubprocess)this.getSubProcessNodeById(diagram, SUBPROCESS_LEVEL_EMPTY_SUBPROCESS_ID, 1, 0);
        this.assertGeneralSet(subProcessLevelSubProcess.getGeneral(), DEFAULT_CALLED_ELEMENT, DEFAULT_CALLED_ELEMENT);
        this.assertReusableSubProcessExecutionSet((BaseReusableSubprocessTaskExecutionSet)subProcessLevelSubProcess.getExecutionSet(), DEFAULT_CALLED_ELEMENT, false, false, false, DEFAULT_CALLED_ELEMENT, TASK_SCRIPT_JAVA_LANGUAGE, DEFAULT_CALLED_ELEMENT, TASK_SCRIPT_JAVA_LANGUAGE, DEFAULT_CALLED_ELEMENT);
        this.assertDataIOSet(subProcessLevelSubProcess.getDataIOSet(), DEFAULT_SUB_PROCESS_DATA_INPUT_OUTPUT);
    }

    @Override
    @Test
    public void testUnmarshallSubProcessLevelFilledPropertiesSubProcess() {
        String SUB_PROCESS_NAME = "Reusable process03 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String SUB_PROCESS_DOCUMENTATION = "Reusable process03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String CALLED_ELEMENT = "testProject.linkedReusableSubProcess";
        String SUB_PROCESS_DATA_INPUT_OUTPUT = "|input:String||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 18);
        ReusableSubprocess subProcessLevelSubProcessJava = (ReusableSubprocess)this.getSubProcessNodeById(diagram, SUBPROCESS_LEVEL_FILLED_SUBPROCESS_JAVA_ID, 1, 0);
        this.assertGeneralSet(subProcessLevelSubProcessJava.getGeneral(), "Reusable process03 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Reusable process03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertReusableSubProcessExecutionSet((BaseReusableSubprocessTaskExecutionSet)subProcessLevelSubProcessJava.getExecutionSet(), "testProject.linkedReusableSubProcess", true, true, true, "System.out.println(\"On Entry Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");", TASK_SCRIPT_JAVA_LANGUAGE, "System.out.println(\"On Exit Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");", TASK_SCRIPT_JAVA_LANGUAGE, SLA_DUE_DATE);
        this.assertDataIOSet(subProcessLevelSubProcessJava.getDataIOSet(), "|input:String||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar");
        ReusableSubprocess subProcessLevelSubProcessJavascript = (ReusableSubprocess)this.getSubProcessNodeById(diagram, SUBPROCESS_LEVEL_FILLED_SUBPROCESS_JAVASCRIPT_ID, 1, 0);
        this.assertGeneralSet(subProcessLevelSubProcessJavascript.getGeneral(), "Reusable process03 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Reusable process03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertReusableSubProcessExecutionSet((BaseReusableSubprocessTaskExecutionSet)subProcessLevelSubProcessJavascript.getExecutionSet(), "testProject.linkedReusableSubProcess", true, true, true, TASK_ON_ENTRY_ACTION_JAVASCRIPT, TASK_SCRIPT_JAVASCRIPT_LANGUAGE, TASK_ON_EXIT_ACTION_JAVASCRIPT, TASK_SCRIPT_JAVASCRIPT_LANGUAGE, SLA_DUE_DATE);
        this.assertDataIOSet(subProcessLevelSubProcessJavascript.getDataIOSet(), "|input:String||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar");
        ReusableSubprocess subProcessLevelSubProcessMVEL = (ReusableSubprocess)this.getSubProcessNodeById(diagram, SUBPROCESS_LEVEL_FILLED_SUBPROCESS_MVEL_ID, 1, 0);
        this.assertGeneralSet(subProcessLevelSubProcessMVEL.getGeneral(), "Reusable process03 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Reusable process03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertReusableSubProcessExecutionSet((BaseReusableSubprocessTaskExecutionSet)subProcessLevelSubProcessMVEL.getExecutionSet(), "testProject.linkedReusableSubProcess", true, true, true, "System.out.println(\"On Entry Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");", TASK_SCRIPT_MVEL_LANGUAGE, "System.out.println(\"On Exit Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");", TASK_SCRIPT_MVEL_LANGUAGE, SLA_DUE_DATE);
        this.assertDataIOSet(subProcessLevelSubProcessMVEL.getDataIOSet(), "|input:String||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar");
    }

    @Override
    @Test
    public void testUnmarshallSubProcessLevelSubProcessWithEdges() {
        String SUB_PROCESS_NAME = "Sub-process";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 18);
        ReusableSubprocess subProcessLevelSubProcessJava = (ReusableSubprocess)this.getSubProcessNodeById(diagram, SUBPROCESS_LEVEL_SUBPROCESS_WITH_EDGES, 2, 2);
        this.assertGeneralSet(subProcessLevelSubProcessJava.getGeneral(), "Sub-process", DEFAULT_CALLED_ELEMENT);
        this.assertReusableSubProcessExecutionSet((BaseReusableSubprocessTaskExecutionSet)subProcessLevelSubProcessJava.getExecutionSet(), DEFAULT_CALLED_ELEMENT, false, false, true, "System.out.println(\"On Entry Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");", TASK_SCRIPT_JAVA_LANGUAGE, "System.out.println(\"On Exit Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");", TASK_SCRIPT_JAVA_LANGUAGE, DEFAULT_CALLED_ELEMENT);
        this.assertDataIOSet(subProcessLevelSubProcessJava.getDataIOSet(), DEFAULT_SUB_PROCESS_DATA_INPUT_OUTPUT);
    }

    @Override
    @Test
    public void testMarshallTopLevelSubProcessWithEdges() {
        this.checkSubProcessMarshalling(this.getTopLevelSubProcessWithEdgesId(), 2, 2);
    }

    @Override
    @Test
    public void testMarshallSubProcessLevelSubProcessWithEdges() {
        this.checkSubProcessMarshalling(this.getSubProcessLevelSubProcessWithEdgesId(), 2, 2);
    }

    @Override
    Class<ReusableSubprocess> getSubProcessType() {
        return ReusableSubprocess.class;
    }

    @Override
    String getBpmnSubProcessFilePath() {
        return BPMN_SUB_PROCESS_FILE_PATH;
    }

    @Override
    String getTopLevelEmptyPropertiesSubProcessId() {
        return TOP_LEVEL_EMPTY_SUBPROCESS_ID;
    }

    @Override
    String[] getTopLevelFilledPropertiesSubProcessesIds() {
        return new String[]{TOP_LEVEL_FILLED_SUBPROCESS_JAVA_ID, TOP_LEVEL_FILLED_SUBPROCESS_JAVASCRIPT_ID, TOP_LEVEL_FILLED_SUBPROCESS_MVEL_ID};
    }

    @Override
    String getTopLevelSubProcessWithEdgesId() {
        return TOP_LEVEL_SUBPROCESS_WITH_EDGES;
    }

    @Override
    String getSubProcessLevelEmptyPropertiesSubProcessId() {
        return SUBPROCESS_LEVEL_EMPTY_SUBPROCESS_ID;
    }

    @Override
    String[] getSubProcessLevelFilledPropertiesSubProcessesIds() {
        return new String[]{SUBPROCESS_LEVEL_FILLED_SUBPROCESS_JAVA_ID, SUBPROCESS_LEVEL_FILLED_SUBPROCESS_JAVASCRIPT_ID, SUBPROCESS_LEVEL_FILLED_SUBPROCESS_MVEL_ID};
    }

    @Override
    String getSubProcessLevelSubProcessWithEdgesId() {
        return SUBPROCESS_LEVEL_SUBPROCESS_WITH_EDGES;
    }

    private void assertReusableSubProcessExecutionSet(BaseReusableSubprocessTaskExecutionSet executionSet, String calledElement, boolean independent, boolean isAsync, boolean waitForCompletion, String onEntryActionScriptValue, String onEntryActionScriptLanguage, String onExitActionScriptValue, String onExitActionScriptLanguage, String slaDueDate) {
        Assertions.assertThat((Object)executionSet).isNotNull();
        Assertions.assertThat((Object)executionSet.getCalledElement()).isNotNull();
        Assertions.assertThat((Object)executionSet.getIndependent()).isNotNull();
        Assertions.assertThat((Object)executionSet.getIsAsync()).isNotNull();
        Assertions.assertThat((Object)executionSet.getWaitForCompletion()).isNotNull();
        Assertions.assertThat((Object)executionSet.getSlaDueDate()).isNotNull();
        Assertions.assertThat((Object)executionSet.getOnEntryAction()).isNotNull();
        Assertions.assertThat((Object)executionSet.getOnExitAction()).isNotNull();
        Assertions.assertThat((Object)executionSet.getOnEntryAction().getValue()).isNotNull();
        Assertions.assertThat((Object)executionSet.getOnExitAction().getValue()).isNotNull();
        List onEntryScriptTypeValues = executionSet.getOnEntryAction().getValue().getValues();
        List onExitScriptTypeValues = executionSet.getOnExitAction().getValue().getValues();
        Assertions.assertThat((List)onEntryScriptTypeValues).isNotNull();
        Assertions.assertThat((List)onExitScriptTypeValues).isNotNull();
        Assertions.assertThat((Object)((ScriptTypeValue)onEntryScriptTypeValues.get(0))).isNotNull();
        Assertions.assertThat((Object)((ScriptTypeValue)onExitScriptTypeValues.get(0))).isNotNull();
        Assertions.assertThat((String)executionSet.getCalledElement().getValue()).isEqualTo(calledElement);
        Assertions.assertThat((Boolean)executionSet.getIndependent().getValue()).isEqualTo(independent);
        Assertions.assertThat((Boolean)executionSet.getIsAsync().getValue()).isEqualTo(isAsync);
        Assertions.assertThat((Boolean)executionSet.getWaitForCompletion().getValue()).isEqualTo(waitForCompletion);
        Assertions.assertThat((String)executionSet.getSlaDueDate().getValue()).contains(new CharSequence[]{slaDueDate});
        Assertions.assertThat((String)((ScriptTypeValue)onEntryScriptTypeValues.get(0)).getScript()).isEqualTo(onEntryActionScriptValue);
        Assertions.assertThat((String)((ScriptTypeValue)onEntryScriptTypeValues.get(0)).getLanguage()).isEqualTo(onEntryActionScriptLanguage);
        Assertions.assertThat((String)((ScriptTypeValue)onExitScriptTypeValues.get(0)).getScript()).isEqualTo(onExitActionScriptValue);
        Assertions.assertThat((String)((ScriptTypeValue)onExitScriptTypeValues.get(0)).getLanguage()).isEqualTo(onExitActionScriptLanguage);
    }

    private void assertDataIOSet(DataIOSet dataIOSet, String value) {
        Assertions.assertThat((Object)dataIOSet).isNotNull();
        Assertions.assertThat((Object)dataIOSet.getAssignmentsinfo()).isNotNull();
        Assertions.assertThat((String)dataIOSet.getAssignmentsinfo().getValue()).isEqualTo(value);
    }
}

