/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.pmml_4_2.model.mining;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dmg.pmml.pmml_4_2.descr.CompoundPredicate;
import org.dmg.pmml.pmml_4_2.descr.SimplePredicate;
import org.dmg.pmml.pmml_4_2.descr.SimpleSetPredicate;
import org.kie.pmml.pmml_4_2.model.mining.PredicateRuleProducer;
import org.kie.pmml.pmml_4_2.model.mining.SimpleSegmentPredicate;
import org.kie.pmml.pmml_4_2.model.mining.SimpleSetSegmentPredicate;

public class CompoundSegmentPredicate
implements PredicateRuleProducer {
    private String booleanOperator;
    private List<PredicateRuleProducer> subpredicates = new ArrayList<PredicateRuleProducer>();

    public CompoundSegmentPredicate() {
    }

    public CompoundSegmentPredicate(CompoundPredicate predicate) {
        for (Serializable serializable : predicate.getSimplePredicatesAndCompoundPredicatesAndSimpleSetPredicates()) {
            if (serializable instanceof SimplePredicate) {
                this.subpredicates.add(new SimpleSegmentPredicate((SimplePredicate)serializable));
                continue;
            }
            if (serializable instanceof SimpleSetPredicate) {
                this.subpredicates.add(new SimpleSetSegmentPredicate((SimpleSetPredicate)serializable));
                continue;
            }
            if (!(serializable instanceof CompoundPredicate)) continue;
            this.subpredicates.add(new CompoundSegmentPredicate((CompoundPredicate)serializable));
        }
        this.booleanOperator = predicate.getBooleanOperator();
        if (this.booleanOperator == null) {
            throw new IllegalStateException("PMML-CompoundPredicate: Missing the booleanOperator attribute");
        }
        if (!(this.booleanOperator.equalsIgnoreCase("and") || this.booleanOperator.equalsIgnoreCase("or") || this.booleanOperator.equalsIgnoreCase("xor") || this.booleanOperator.equalsIgnoreCase("surrogate"))) {
            throw new IllegalStateException("PMML-CompoundPredicate: Invalid value (" + this.booleanOperator + ") for the booleanOperator attribute");
        }
    }

    private String buildAndPredicate() {
        StringBuilder bldr = new StringBuilder("(");
        boolean firstPredicate = true;
        for (PredicateRuleProducer ruleProducer : this.subpredicates) {
            if (!firstPredicate) {
                bldr.append(" && ");
            } else {
                firstPredicate = false;
            }
            bldr.append("(").append(ruleProducer.getPredicateRule()).append(")");
        }
        bldr.append(")");
        return bldr.toString();
    }

    private String buildXorPredicate() {
        StringBuilder bldr = new StringBuilder("(");
        boolean firstPredicate = true;
        for (PredicateRuleProducer ruleProducer : this.subpredicates) {
            if (!firstPredicate) {
                bldr.append(" ^ ");
            } else {
                firstPredicate = false;
            }
            bldr.append("(").append(ruleProducer.getPredicateRule()).append(")");
        }
        bldr.append(")");
        return bldr.toString();
    }

    private String buildOrPredicate() {
        StringBuilder bldr = new StringBuilder("(");
        boolean firstPredicate = true;
        for (PredicateRuleProducer ruleProducer : this.subpredicates) {
            if (!firstPredicate) {
                bldr.append(" || ");
            } else {
                firstPredicate = false;
            }
            bldr.append("(").append(ruleProducer.getPredicateRule()).append(")");
        }
        bldr.append(")");
        return bldr.toString();
    }

    @Override
    public List<String> getPredicateFieldNames() {
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (PredicateRuleProducer ruleProducer : this.subpredicates) {
            fieldNames.addAll(ruleProducer.getPredicateFieldNames());
        }
        return fieldNames;
    }

    @Override
    public List<String> getFieldMissingFieldNames() {
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (PredicateRuleProducer ruleProducer : this.subpredicates) {
            fieldNames.addAll(ruleProducer.getFieldMissingFieldNames());
        }
        return fieldNames;
    }

    public String getPrimaryPredicateRule() {
        if (this.booleanOperator.equalsIgnoreCase("surrogate")) {
            PredicateRuleProducer ruleProducer = this.subpredicates.get(0);
            if (ruleProducer != null) {
                return ruleProducer.getPredicateRule();
            }
        } else {
            throw new IllegalStateException("PMML-CompoundPredicate: Primary predicate is only available when operator is \"surrogate\"");
        }
        return null;
    }

    private String calcMissingFields(CompoundSegmentPredicate csp, List<String> fields) {
        StringBuilder bldr = new StringBuilder("( ");
        boolean firstFieldName = true;
        String compoundType = csp.booleanOperator;
        for (String fieldName : fields) {
            if (!firstFieldName) {
                if ("and".equalsIgnoreCase(compoundType)) {
                    bldr.append(" || ");
                } else if ("or".equalsIgnoreCase(compoundType)) {
                    bldr.append(" && ");
                }
            } else {
                firstFieldName = false;
            }
            bldr.append(fieldName).append("==true");
        }
        bldr.append(" )");
        return bldr.toString();
    }

    public String getNextPredicateRule(int lastPredicate) {
        if (this.booleanOperator.equalsIgnoreCase("surrogate")) {
            int index = lastPredicate + 1;
            HashMap<PredicateRuleProducer, Object> missingFieldsMap = new HashMap<PredicateRuleProducer, Object>();
            for (int counter = 0; counter < index; ++counter) {
                PredicateRuleProducer prp = this.subpredicates.get(counter);
                List<String> missingFields = prp.getFieldMissingFieldNames();
                if (missingFields == null || missingFields.isEmpty()) continue;
                missingFieldsMap.put(prp, missingFields);
            }
            if (!missingFieldsMap.isEmpty()) {
                StringBuilder bldr = new StringBuilder("( (");
                boolean firstField = true;
                for (PredicateRuleProducer prp : missingFieldsMap.keySet()) {
                    List mfs = (List)missingFieldsMap.get(prp);
                    if (!firstField) {
                        bldr.append(" && ");
                    } else {
                        firstField = false;
                    }
                    if (prp instanceof CompoundSegmentPredicate) {
                        bldr.append(this.calcMissingFields((CompoundSegmentPredicate)prp, mfs));
                        continue;
                    }
                    bldr.append((String)mfs.get(0)).append(" == true");
                }
                bldr.append(") && ");
                PredicateRuleProducer ruleProducer = this.subpredicates.get(index);
                if (ruleProducer != null) {
                    bldr.append("( ").append(ruleProducer.getPredicateRule()).append(" )");
                }
                bldr.append(" )");
                return bldr.toString();
            }
        } else {
            throw new IllegalStateException("PMML-CompoundPredicate: Sub-predicates are only available when operator is \"surrogate\"");
        }
        return null;
    }

    public int getSubpredicateCount() {
        return this.subpredicates.size() - 1;
    }

    public boolean hasSurrogation() {
        return this.booleanOperator != null && this.booleanOperator.equalsIgnoreCase("surrogate");
    }

    private String buildSurrogationPredicate() {
        StringBuilder builder = new StringBuilder();
        String predicate = this.getPrimaryPredicateRule();
        builder.append("( ").append(predicate).append(" )");
        for (int lastPred = 0; lastPred < this.getSubpredicateCount(); ++lastPred) {
            predicate = this.getNextPredicateRule(lastPred);
            if (predicate == null) continue;
            builder.append(" || ( ").append(predicate).append(" )");
        }
        return builder.toString();
    }

    @Override
    public String getPredicateRule() {
        if (this.booleanOperator.equalsIgnoreCase("and")) {
            return this.buildAndPredicate();
        }
        if (this.booleanOperator.equalsIgnoreCase("or")) {
            return this.buildOrPredicate();
        }
        if (this.booleanOperator.equalsIgnoreCase("xor")) {
            return this.buildXorPredicate();
        }
        if (this.hasSurrogation()) {
            return this.buildSurrogationPredicate();
        }
        return null;
    }

    @Override
    public boolean isAlwaysTrue() {
        return false;
    }

    @Override
    public boolean isAlwaysFalse() {
        return false;
    }
}

