/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.projecteditor.backend.server;

import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.ModuleRepositories;
import org.guvnor.common.services.project.service.DeploymentMode;
import org.guvnor.common.services.project.service.GAVAlreadyExistsException;
import org.guvnor.common.services.project.service.ModuleRepositoriesService;
import org.guvnor.common.services.project.service.ModuleRepositoryResolver;
import org.guvnor.common.services.project.service.POMService;
import org.kie.workbench.common.screens.projecteditor.model.ProjectScreenModel;
import org.kie.workbench.common.services.backend.builder.core.LRUPomModelCache;
import org.kie.workbench.common.services.shared.allowlist.PackageNameAllowListService;
import org.kie.workbench.common.services.shared.kmodule.KModuleService;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.kie.workbench.common.services.shared.project.ProjectImportsService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Option;

public class ProjectScreenModelSaver {
    private POMService pomService;
    private KModuleService kModuleService;
    private ProjectImportsService importsService;
    private ModuleRepositoriesService repositoriesService;
    private PackageNameAllowListService allowListService;
    private IOService ioService;
    private KieModuleService moduleService;
    private ModuleRepositoryResolver repositoryResolver;
    private CommentedOptionFactory commentedOptionFactory;
    private LRUPomModelCache pomModelCache;

    public ProjectScreenModelSaver() {
    }

    @Inject
    public ProjectScreenModelSaver(POMService pomService, KModuleService kModuleService, ProjectImportsService importsService, ModuleRepositoriesService repositoriesService, PackageNameAllowListService allowListService, @Named(value="ioStrategy") IOService ioService, KieModuleService moduleService, ModuleRepositoryResolver repositoryResolver, CommentedOptionFactory commentedOptionFactory, LRUPomModelCache pomModelCache) {
        this.pomService = pomService;
        this.kModuleService = kModuleService;
        this.importsService = importsService;
        this.repositoriesService = repositoriesService;
        this.allowListService = allowListService;
        this.ioService = ioService;
        this.moduleService = moduleService;
        this.repositoryResolver = repositoryResolver;
        this.commentedOptionFactory = commentedOptionFactory;
        this.pomModelCache = pomModelCache;
    }

    public void save(Path pathToPomXML, ProjectScreenModel model, DeploymentMode mode, String comment) {
        if (DeploymentMode.VALIDATED.equals((Object)mode)) {
            this.checkRepositories(pathToPomXML, model);
        }
        try {
            KieModule module = (KieModule)this.moduleService.resolveModule(pathToPomXML);
            this.pomModelCache.invalidateCache((Object)module);
            this.ioService.startBatch(Paths.convert((Path)pathToPomXML).getFileSystem(), new Option[]{this.commentedOptionFactory.makeCommentedOption(comment)});
            this.pomService.save(pathToPomXML, (Object)model.getPOM(), model.getPOMMetaData(), comment);
            this.kModuleService.save(model.getPathToKModule(), (Object)model.getKModule(), model.getKModuleMetaData(), comment);
            this.importsService.save(model.getPathToImports(), (Object)model.getProjectImports(), model.getProjectImportsMetaData(), comment);
            this.repositoriesService.save(model.getPathToRepositories(), model.getRepositories(), comment);
            this.allowListService.save(model.getPathToAllowList(), (Object)model.getAllowList(), model.getAllowListMetaData(), comment);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.ioService.endBatch();
        }
    }

    private void checkRepositories(Path pathToPomXML, ProjectScreenModel model) {
        KieModule project;
        GAV gav = model.getPOM().getGav();
        if (gav.equals((Object)(project = (KieModule)this.moduleService.resolveModule(pathToPomXML)).getPom().getGav())) {
            return;
        }
        if (gav.isSnapshot()) {
            return;
        }
        ModuleRepositories moduleRepositories = model.getRepositories();
        Set repositories = this.repositoryResolver.getRepositoriesResolvingArtifact(gav, (Module)project, moduleRepositories.filterByIncluded());
        if (repositories.size() > 0) {
            throw new GAVAlreadyExistsException(gav, repositories);
        }
    }
}

