/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.backend.version;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.uberfire.ext.editor.commons.backend.version.VersionRecordService;
import org.uberfire.ext.editor.commons.backend.version.VersionUtil;
import org.uberfire.ext.editor.commons.version.impl.PortableVersionRecord;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.version.VersionAttributeView;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.java.nio.file.Path;

public class VersionRecordServiceImpl
implements VersionRecordService {
    private IOService ioService;
    private VersionUtil util;

    public VersionRecordServiceImpl() {
    }

    @Inject
    public VersionRecordServiceImpl(@Named(value="ioStrategy") IOService ioService, VersionUtil util) {
        this.ioService = ioService;
        this.util = util;
    }

    public List<VersionRecord> load(Path path) {
        List<VersionRecord> records = this.loadVersionRecords(path);
        List<VersionRecord> result = this.loadVersionRecords(this.util.getDotFilePath(path));
        for (VersionRecord record : records) {
            if (!this.doesNotContainID(record.id(), result)) continue;
            result.add(record);
        }
        Collections.sort(result, new VersionRecordComparator());
        return result;
    }

    public List<VersionRecord> loadVersionRecords(Path path) {
        if (this.ioService.exists(path)) {
            ArrayList<VersionRecord> portableRecords = new ArrayList<VersionRecord>();
            for (VersionRecord versionRecord : ((VersionAttributeView)this.ioService.getFileAttributeView(path, VersionAttributeView.class)).readAttributes().history().records()) {
                portableRecords.add((VersionRecord)this.makePortable(versionRecord));
            }
            return portableRecords;
        }
        return new ArrayList<VersionRecord>();
    }

    private PortableVersionRecord makePortable(VersionRecord record) {
        return new PortableVersionRecord(record.id(), record.author(), record.email(), record.comment(), record.date(), record.uri());
    }

    private boolean doesNotContainID(String id, List<VersionRecord> records) {
        for (VersionRecord record : records) {
            if (!record.id().equals(id)) continue;
            return false;
        }
        return true;
    }

    public VersionRecord loadRecord(Path path) throws URISyntaxException {
        for (VersionRecord record : this.loadVersionRecords(this.util.getPath(path, "master"))) {
            String version = this.util.getVersion(path);
            if ("master".equals(version)) {
                return record;
            }
            if (!record.id().equals(version)) continue;
            return record;
        }
        return null;
    }

    private class VersionRecordComparator
    implements Comparator<VersionRecord> {
        private VersionRecordComparator() {
        }

        @Override
        public int compare(VersionRecord left, VersionRecord right) {
            int compareTo = left.date().compareTo(right.date());
            if (compareTo == 0) {
                return this.compareUri(right.uri(), left.uri());
            }
            return compareTo;
        }

        private int compareUri(String rightUri, String leftUri) {
            Iterator<Character> right = this.getReversedIterator(rightUri);
            Iterator<Character> left = this.getReversedIterator(leftUri);
            while (left.hasNext() && right.hasNext()) {
                Character l = left.next();
                Character r = right.next();
                if (l.equals(Character.valueOf('.')) && !r.equals(Character.valueOf('.'))) {
                    return 1;
                }
                if (l.equals(Character.valueOf('.')) || !r.equals(Character.valueOf('.'))) continue;
                return -1;
            }
            return 0;
        }

        private Iterator<Character> getReversedIterator(String uri) {
            ArrayList<Character> chars = new ArrayList<Character>();
            for (char c : uri.toCharArray()) {
                chars.add(Character.valueOf(c));
            }
            Collections.reverse(chars);
            return chars.iterator();
        }
    }
}

