/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1.dd;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.kie.dmn.model.api.dmndi.Bounds;
import org.kie.dmn.model.api.dmndi.DMNShape;
import org.kie.dmn.model.v1_2.dmndi.Point;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bound;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

public class PointUtils {
    private PointUtils() {
    }

    public static org.kie.dmn.model.api.dmndi.Point point2dToDMNDIPoint(Point2D point2d) {
        Point result = new Point();
        result.setX(point2d.getX());
        result.setY(point2d.getY());
        return result;
    }

    public static Point2D dmndiPointToPoint2D(org.kie.dmn.model.api.dmndi.Point dmndiPoint) {
        Point2D result = new Point2D(dmndiPoint.getX(), dmndiPoint.getY());
        return result;
    }

    public static void convertToAbsoluteBounds(Node<?, ?> targetNode) {
        PointUtils.convertBounds(targetNode, (base, delta) -> base + delta);
    }

    public static void convertToRelativeBounds(Node<?, ?> targetNode) {
        PointUtils.convertBounds(targetNode, (base, delta) -> base - delta);
    }

    private static void convertBounds(Node<?, ?> targetNode, BiFunction<Double, Double, Double> convertor) {
        if (targetNode.getContent() instanceof View) {
            View targetNodeView = (View)targetNode.getContent();
            double boundsX = PointUtils.xOfBound(PointUtils.upperLeftBound(targetNodeView));
            double boundsY = PointUtils.yOfBound(PointUtils.upperLeftBound(targetNodeView));
            double boundsWidth = PointUtils.xOfBound(PointUtils.lowerRightBound(targetNodeView)) - boundsX;
            double boundsHeight = PointUtils.yOfBound(PointUtils.lowerRightBound(targetNodeView)) - boundsY;
            List inEdges = targetNode.getInEdges();
            for (Edge e : inEdges) {
                if (!(e.getContent() instanceof Child)) continue;
                Node sourceNode = e.getSourceNode();
                View sourceView = (View)sourceNode.getContent();
                Bound sourceViewULBound = sourceView.getBounds().getUpperLeft();
                double dx = sourceViewULBound.getX();
                double dy = sourceViewULBound.getY();
                boundsX = convertor.apply(boundsX, dx);
                boundsY = convertor.apply(boundsY, dy);
                targetNodeView.setBounds(org.kie.workbench.common.stunner.core.graph.content.Bounds.create((double)boundsX, (double)boundsY, (double)(boundsX + boundsWidth), (double)(boundsY + boundsHeight)));
                break;
            }
        }
    }

    public static double xOfShape(DMNShape shape) {
        return PointUtils.extractValue(shape, Bounds::getX);
    }

    public static double yOfShape(DMNShape shape) {
        return PointUtils.extractValue(shape, Bounds::getY);
    }

    public static double widthOfShape(DMNShape shape) {
        return PointUtils.extractValue(shape, Bounds::getWidth);
    }

    public static double heightOfShape(DMNShape shape) {
        return PointUtils.extractValue(shape, Bounds::getHeight);
    }

    public static Bound upperLeftBound(View view) {
        return PointUtils.extractBounds(view, org.kie.workbench.common.stunner.core.graph.content.Bounds::getUpperLeft);
    }

    public static Bound lowerRightBound(View view) {
        return PointUtils.extractBounds(view, org.kie.workbench.common.stunner.core.graph.content.Bounds::getLowerRight);
    }

    public static double xOfBound(Bound bound) {
        return PointUtils.extractBound(bound, Bound::getX);
    }

    public static double yOfBound(Bound bound) {
        return PointUtils.extractBound(bound, Bound::getY);
    }

    private static double extractValue(DMNShape shape, Function<Bounds, Double> extractor) {
        if (shape != null && shape.getBounds() != null) {
            return extractor.apply(shape.getBounds());
        }
        return 0.0;
    }

    private static Bound extractBounds(View view, Function<org.kie.workbench.common.stunner.core.graph.content.Bounds, Bound> extractor) {
        if (view != null && view.getBounds() != null) {
            return extractor.apply(view.getBounds());
        }
        return null;
    }

    private static double extractBound(Bound bound, Function<Bound, Double> extractor) {
        if (bound != null) {
            return extractor.apply(bound);
        }
        return 0.0;
    }
}

