/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.authz;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.TreeMap;

public class NonEscapedProperties
extends TreeMap<String, String> {
    private static final long serialVersionUID = 1L;

    public NonEscapedProperties() {
    }

    public NonEscapedProperties(Comparator<? super String> comparator) {
        super(comparator);
    }

    public void load(Reader reader) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(reader);
        while ((line = br.readLine()) != null) {
            this.putLine(line);
        }
    }

    public void load(Path file) throws IOException {
        for (String line : Files.readAllLines(file)) {
            this.putLine(line);
        }
    }

    public void store(Writer writer, String ... comments) throws IOException {
        StringBuilder out = new StringBuilder();
        if (comments != null) {
            for (String comment : comments) {
                out.append("# ").append(comment).append("\n");
            }
            out.append("\n");
        }
        this.forEach((key, value) -> out.append((String)key).append("=").append((String)value).append("\n"));
        writer.write(out.toString());
        writer.flush();
    }

    private void putLine(String line) {
        String _line;
        if (line != null && !(_line = line.trim()).isEmpty() && !_line.startsWith("#")) {
            String[] tokens = _line.split("=");
            if (tokens.length == 1) {
                super.put(tokens[0], "");
            }
            if (tokens.length == 2) {
                super.put(tokens[0], tokens[1]);
            }
        }
    }
}

