/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.security.elytron;

import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.exception.FailedAuthenticationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.security.elytron.ElytronIdentityHelper;
import org.uberfire.security.WorkbenchUserManager;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;

@Alternative
public class DefaultElytronIdentityHelper
implements ElytronIdentityHelper {
    private static final Logger logger = LoggerFactory.getLogger(DefaultElytronIdentityHelper.class);
    private final WorkbenchUserManager workbenchUserManager;

    @Inject
    public DefaultElytronIdentityHelper(WorkbenchUserManager workbenchUserManager) {
        this.workbenchUserManager = workbenchUserManager;
    }

    @Override
    public User getIdentity(String userName, String password) {
        try {
            if (this.login(userName, password)) {
                return this.workbenchUserManager.getUser(userName);
            }
        }
        catch (Exception ex) {
            logger.debug("Identity provided for '{}' not valid", (Object)userName);
        }
        throw new FailedAuthenticationException();
    }

    protected boolean login(String userName, String password) {
        PasswordGuessEvidence evidence = new PasswordGuessEvidence(password.toCharArray());
        try {
            SecurityDomain.getCurrent().authenticate(userName, (Evidence)evidence);
            return true;
        }
        catch (Exception e) {
            throw new FailedAuthenticationException(e.getMessage());
        }
    }
}

