/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;

public class FileUtils {
    protected FileUtils() {
    }

    public static FileUtils getInstance() {
        return new FileUtils();
    }

    public Collection<ScanResult> scan(IOService ioService, Collection<Path> rootPaths, String fileType, boolean recursiveScan) throws IOException {
        ArrayList<String> fileTypes = new ArrayList<String>();
        fileTypes.add(fileType);
        return this.scan(ioService, rootPaths, fileTypes, recursiveScan);
    }

    public Collection<ScanResult> scan(IOService ioService, Collection<Path> rootPaths, Collection<String> fileTypes, boolean recursiveScan) throws IOException {
        ArrayList<ScanResult> results = new ArrayList<ScanResult>();
        HashMap<Path, Path> scannedCache = new HashMap<Path, Path>();
        if (rootPaths != null) {
            for (Path root : rootPaths) {
                if (Files.isDirectory((Path)root, (LinkOption[])new LinkOption[0]) && !scannedCache.containsKey(root)) {
                    results.addAll(this.scan(ioService, root, fileTypes, recursiveScan, scannedCache));
                    continue;
                }
                if (fileTypes != null && !this.isFromType(root, fileTypes) || scannedCache.containsKey(root)) continue;
                results.add(new ScanResult(root));
                scannedCache.put(root, root);
            }
        }
        return results;
    }

    public Collection<ScanResult> scan(IOService ioService, Path root, Collection<String> fileTypes, boolean recursiveScan) throws IOException {
        ArrayList<Path> roots = new ArrayList<Path>();
        roots.add(root);
        return this.scan(ioService, roots, fileTypes, recursiveScan);
    }

    private Collection<ScanResult> scan(IOService ioService, Path rootPath, final Collection<String> fileTypes, final boolean recursiveScan, Map<Path, Path> scannedCache) throws IOException {
        ArrayList<ScanResult> results = new ArrayList<ScanResult>();
        final ArrayList childDirectories = new ArrayList();
        if (rootPath != null && Files.isDirectory((Path)rootPath, (LinkOption[])new LinkOption[0]) && !scannedCache.containsKey(rootPath)) {
            scannedCache.put(rootPath, rootPath);
            DirectoryStream foundFiles = ioService.newDirectoryStream(rootPath, (DirectoryStream.Filter)new DirectoryStream.Filter<Path>(){

                public boolean accept(Path entry) throws IOException {
                    boolean include = false;
                    if (Files.isDirectory((Path)entry, (LinkOption[])new LinkOption[0]) && recursiveScan) {
                        childDirectories.add(entry);
                    } else {
                        include = fileTypes == null ? true : FileUtils.this.isFromType(entry, fileTypes);
                    }
                    return include;
                }
            });
            if (foundFiles != null) {
                for (Path acceptedFile : foundFiles) {
                    results.add(new ScanResult(acceptedFile));
                }
            }
            if (recursiveScan) {
                for (Path child : childDirectories) {
                    results.addAll(this.scan(ioService, child, fileTypes, recursiveScan, scannedCache));
                }
            }
        }
        return results;
    }

    private boolean isFromType(Path file, Collection<String> fileTypes) {
        if (Files.isDirectory((Path)file, (LinkOption[])new LinkOption[0])) {
            return false;
        }
        for (String type : fileTypes) {
            if (!file.getFileName().toString().endsWith(type) || file.getFileName().toString().startsWith(".")) continue;
            return true;
        }
        return false;
    }

    public Collection<ScanResult> scanDirectories(IOService ioService, Path rootPath, boolean includeRoot, boolean recursiveScan) throws IOException {
        ArrayList<ScanResult> results = new ArrayList<ScanResult>();
        ArrayList childDirectories = new ArrayList();
        if (rootPath != null && Files.isDirectory((Path)rootPath, (LinkOption[])new LinkOption[0])) {
            if (includeRoot) {
                results.add(new ScanResult(rootPath));
            }
            DirectoryStream children = ioService.newDirectoryStream(rootPath);
            if (recursiveScan) {
                for (Path child : children) {
                    results.addAll(this.scanDirectories(ioService, child, true, recursiveScan));
                }
            }
        }
        return results;
    }

    public boolean cleanEmptyDirectories(IOService ioService, Path rootPath, boolean deleteRoot, List<String> deleteableFiles) throws IOException {
        if (rootPath != null && Files.exists((Path)rootPath, (LinkOption[])new LinkOption[0]) && Files.isDirectory((Path)rootPath, (LinkOption[])new LinkOption[0])) {
            DirDescriptor dirDescriptor;
            DirectoryStream children = ioService.newDirectoryStream(rootPath);
            if (children != null) {
                for (Path child : children) {
                    if (!Files.isDirectory((Path)child, (LinkOption[])new LinkOption[0])) continue;
                    this.cleanEmptyDirectories(ioService, child, true, deleteableFiles);
                }
            }
            if ((dirDescriptor = this.isDeleteableDir(ioService, rootPath, deleteableFiles)).isDeleteable()) {
                for (Path child : dirDescriptor.getChildren()) {
                    ioService.delete(child, new DeleteOption[0]);
                }
                if (deleteRoot) {
                    ioService.deleteIfExists(rootPath, new DeleteOption[0]);
                    return true;
                }
            }
        }
        return false;
    }

    public DirDescriptor isDeleteableDir(IOService ioService, Path dirPath, List<String> deleteableFiles) throws IOException {
        DirDescriptor dirDescriptor = new DirDescriptor(dirPath);
        boolean deleteable = false;
        DirectoryStream children = ioService.newDirectoryStream(dirPath);
        if (children == null) {
            deleteable = true;
        } else {
            Iterator iterator = children.iterator();
            if (iterator == null) {
                deleteable = true;
            } else {
                deleteable = true;
                for (Path child : children) {
                    if (Files.isDirectory((Path)child, (LinkOption[])new LinkOption[0])) {
                        dirDescriptor.setDeleteable(false);
                        return dirDescriptor;
                    }
                    for (String deleteableFile : deleteableFiles) {
                        if (!child.getFileName().endsWith(deleteableFile)) {
                            dirDescriptor.setDeleteable(false);
                            return dirDescriptor;
                        }
                        dirDescriptor.addChild(child);
                    }
                }
            }
        }
        dirDescriptor.setDeleteable(deleteable);
        return dirDescriptor;
    }

    public boolean isEmpty(IOService ioService, Path dirPath) throws IOException {
        if (dirPath == null) {
            return true;
        }
        DirectoryStream children = ioService.newDirectoryStream(dirPath);
        if (children == null) {
            return true;
        }
        Iterator iterator = children.iterator();
        return iterator == null || !iterator.hasNext();
    }

    public class ScanResult {
        private Path file;

        public ScanResult(Path file) {
            this.file = file;
        }

        public Path getFile() {
            return this.file;
        }

        public void setFile(Path file) {
            this.file = file;
        }
    }

    class DirDescriptor {
        private boolean deleteable = false;
        private List<Path> children = new ArrayList<Path>();
        private Path path;

        DirDescriptor(Path path) {
            this.path = path;
        }

        public boolean isDeleteable() {
            return this.deleteable;
        }

        public void setDeleteable(boolean deleteable) {
            this.deleteable = deleteable;
        }

        public List<Path> getChildren() {
            return this.children;
        }

        public void addChild(Path child) {
            this.children.add(child);
        }
    }
}

