/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties;

import java.util.Optional;
import org.eclipse.bpmn2.Assignment;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.Task;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomInput;

public abstract class CustomInputDefinition<T> {
    protected final T defaultValue;
    private final String name;
    private final String type;

    public CustomInputDefinition(String name, String type, T defaultValue) {
        this.name = name;
        this.type = type;
        this.defaultValue = defaultValue;
    }

    private static Object evaluate(Assignment assignment) {
        return ((FormalExpression)assignment.getFrom()).getBody();
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public abstract T getValue(Task var1);

    Optional<String> getStringValue(Task element) {
        for (DataInputAssociation din : element.getDataInputAssociations()) {
            DataInput targetRef = (DataInput)din.getTargetRef();
            if (!targetRef.getName().equalsIgnoreCase(this.name) || din.getAssignment().isEmpty()) continue;
            Assignment assignment = (Assignment)din.getAssignment().get(0);
            return Optional.of(CustomInputDefinition.evaluate(assignment).toString());
        }
        return Optional.empty();
    }

    public CustomInput<T> of(Task element) {
        return new CustomInput(this, element);
    }
}

