/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.command.impl;

import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCompositeCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.SetConnectionSourceNodeCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.SetConnectionTargetNodeCommand;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;

@Portable
public class DeleteConnectorCommand
extends AbstractGraphCompositeCommand {
    private final String edgeUUID;
    private transient Edge<? extends View, Node> edge;

    public DeleteConnectorCommand(@MapsTo(value="edge") String edgeUUID) {
        this.edgeUUID = (String)PortablePreconditions.checkNotNull((String)"edgeUUID", (Object)edgeUUID);
    }

    public DeleteConnectorCommand(Edge<? extends View, Node> edge) {
        this(edge.getUUID());
        this.edge = edge;
    }

    protected DeleteConnectorCommand initialize(GraphCommandExecutionContext context) {
        super.initialize(context);
        Edge<? extends ViewConnector, Node> edge = this.getCandidateEdge(context);
        Node targetNode = edge.getTargetNode();
        Node sourceNode = edge.getSourceNode();
        if (null != sourceNode) {
            this.commands.add(this.getSetConnectionSourceCommand(edge));
        }
        if (null != targetNode) {
            this.commands.add(this.getSetConnectionTargetCommand(edge));
        }
        return this;
    }

    protected SetConnectionTargetNodeCommand getSetConnectionTargetCommand(Edge<? extends ViewConnector, Node> edge) {
        return new SetConnectionTargetNodeCommand(null, edge);
    }

    protected SetConnectionSourceNodeCommand getSetConnectionSourceCommand(Edge<? extends ViewConnector, Node> edge) {
        return new SetConnectionSourceNodeCommand(null, edge);
    }

    @Override
    public CommandResult<RuleViolation> execute(GraphCommandExecutionContext context) {
        CommandResult result = super.execute(context);
        if (!CommandUtils.isError(result)) {
            Edge<? extends ViewConnector, Node> edge = this.getCandidateEdge(context);
            this.getMutableIndex(context).removeEdge(edge);
        }
        return result;
    }

    @Override
    public CommandResult<RuleViolation> undo(GraphCommandExecutionContext context) {
        this.getMutableIndex(context).addEdge(this.edge);
        CommandResult result = super.undo(context);
        if (CommandUtils.isError(result)) {
            this.getMutableIndex(context).removeEdge(this.edge);
        }
        return result;
    }

    private Edge<? extends ViewConnector, Node> getCandidateEdge(GraphCommandExecutionContext context) {
        if (null == this.edge) {
            this.edge = this.getViewEdge(context, this.edgeUUID);
        }
        return this.edge;
    }

    public Edge<? extends View, Node> getEdge() {
        return this.edge;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[edge=" + this.edgeUUID + "]";
    }

    @Override
    protected boolean delegateRulesContextToChildren() {
        return true;
    }
}

