/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.lookup.domain;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;
import org.kie.workbench.common.stunner.core.lookup.domain.DomainLookupContext;
import org.kie.workbench.common.stunner.core.lookup.domain.DomainLookupsCache;
import org.kie.workbench.common.stunner.core.rule.RuleEvaluationContext;
import org.kie.workbench.common.stunner.core.rule.RuleViolations;
import org.kie.workbench.common.stunner.core.rule.context.CardinalityContext;
import org.kie.workbench.common.stunner.core.rule.context.EdgeCardinalityContext;
import org.kie.workbench.common.stunner.core.rule.context.impl.RuleEvaluationContextBuilder;
import org.kie.workbench.common.stunner.core.rule.impl.CanConnect;
import org.kie.workbench.common.stunner.core.validation.Violation;

public class DomainLookupFunctions {
    public static boolean isSourceConnectionAllowed(CanConnect rule, Set<String> labels) {
        return rule.getPermittedConnections().stream().anyMatch(pc -> labels.contains(pc.getStartRole()));
    }

    private static <T> int countOutgoingEdges(DomainLookupContext context, Node<? extends Definition<T>, ? extends Edge> sourceNode, String edgeId) {
        List edges = sourceNode.getOutEdges();
        return GraphUtils.countEdges(context.getDefinitionManager(), edgeId, edges);
    }

    private static boolean isValid(RuleViolations violations) {
        return null == violations || !violations.violations(Violation.Type.ERROR).iterator().hasNext();
    }

    public static class LookupDefinitionsByLabels
    implements DomainLookupFunction {
        private final Set<String> labels;
        private final Predicate<String> definitionIdsAllowedFilter;

        public LookupDefinitionsByLabels(Set<String> labels, Predicate<String> definitionIdsAllowedFilter) {
            this.labels = labels;
            this.definitionIdsAllowedFilter = definitionIdsAllowedFilter;
        }

        @Override
        public Set<String> execute(DomainLookupContext context) {
            DomainLookupsCache cache = context.getCache();
            return this.labels.stream().flatMap(label -> cache.getDefinitions((String)label).stream()).filter(this.definitionIdsAllowedFilter::test).collect(Collectors.toSet());
        }
    }

    public static class LookupAllowedDefinitionsByLabels
    implements DomainLookupFunction {
        private final Graph<?, ? extends Node> graph;
        private final Set<String> labels;
        private final Predicate<String> definitionIdsAllowedFilter;

        public LookupAllowedDefinitionsByLabels(Graph<?, ? extends Node> graph, Set<String> labels, Predicate<String> definitionIdsAllowedFilter) {
            this.graph = graph;
            this.labels = labels;
            this.definitionIdsAllowedFilter = definitionIdsAllowedFilter;
        }

        @Override
        public Set<String> execute(DomainLookupContext context) {
            Set<String> ids = new LookupDefinitionsByLabels(this.labels, this.definitionIdsAllowedFilter).execute(context);
            Map<String, Integer> graphLabelCount = GraphUtils.getLabelsCount(this.graph, this.labels);
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            for (String defId : ids) {
                Set<String> defLabels = context.getDefinitionsRegistry().getLabels(defId);
                for (String label : defLabels) {
                    Integer roleCount = Optional.ofNullable(graphLabelCount.get(label)).orElse(0);
                    RuleViolations violations = context.getRuleManager().evaluate(context.getCache().getRuleSet(), (RuleEvaluationContext)RuleEvaluationContextBuilder.DomainContexts.cardinality(Collections.singleton(label), roleCount, Optional.of(CardinalityContext.Operation.ADD)));
                    if (!DomainLookupFunctions.isValid(violations)) continue;
                    result.add(defId);
                }
            }
            return result;
        }
    }

    public static class LookupConnectionTargetRoles
    implements DomainLookupFunction {
        private final String edgeDefId;
        private final String sourceNodeDefId;

        public LookupConnectionTargetRoles(String edgeDefId, String sourceNodeDefId) {
            this.edgeDefId = edgeDefId;
            this.sourceNodeDefId = sourceNodeDefId;
        }

        @Override
        public Set<String> execute(DomainLookupContext context) {
            Set<String> labels = context.getDefinitionsRegistry().getLabels(this.sourceNodeDefId);
            return context.getCache().getConnectionRules().stream().filter(rule -> rule.getRole().equals(this.edgeDefId)).flatMap(rule -> rule.getPermittedConnections().stream()).filter(pc -> labels.contains(pc.getStartRole())).map(CanConnect.PermittedConnection::getEndRole).collect(Collectors.toSet());
        }
    }

    public static class LookupTargetConnectors
    implements DomainLookupFunction {
        private final Node<? extends Definition<Object>, ? extends Edge> sourceNode;

        public LookupTargetConnectors(Node<? extends Definition<Object>, ? extends Edge> sourceNode) {
            this.sourceNode = sourceNode;
        }

        @Override
        public Set<String> execute(DomainLookupContext context) {
            DomainLookupsCache cache = context.getCache();
            Set labels = this.sourceNode.getLabels();
            Set allowedTargetConnectors = context.getCache().getConnectionRules().stream().filter(rule -> DomainLookupFunctions.isSourceConnectionAllowed(rule, labels)).map(CanConnect::getRole).collect(Collectors.toSet());
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            for (String allowedConnector : allowedTargetConnectors) {
                int outEdgeCount = DomainLookupFunctions.countOutgoingEdges(context, this.sourceNode, allowedConnector);
                RuleViolations outEdgeCardinalityResult = context.getRuleManager().evaluate(cache.getRuleSet(), (RuleEvaluationContext)RuleEvaluationContextBuilder.DomainContexts.edgeCardinality(this.sourceNode.getLabels(), allowedConnector, outEdgeCount, EdgeCardinalityContext.Direction.OUTGOING, Optional.of(CardinalityContext.Operation.ADD)));
                if (!DomainLookupFunctions.isValid(outEdgeCardinalityResult)) continue;
                result.add(allowedConnector);
            }
            return result;
        }
    }

    public static class FilterConnectionTargetDefinitions
    implements DomainLookupFunction {
        private final String edgeId;
        private final Set<String> definitionIds;

        public FilterConnectionTargetDefinitions(String edgeId, Set<String> definitionIds) {
            this.edgeId = edgeId;
            this.definitionIds = definitionIds;
        }

        @Override
        public Set<String> execute(DomainLookupContext context) {
            DomainLookupsCache cache = context.getCache();
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            for (String definitionId : this.definitionIds) {
                Set<String> labels = context.getDefinitionsRegistry().getLabels(definitionId);
                RuleViolations violations = context.getRuleManager().evaluate(cache.getRuleSet(), (RuleEvaluationContext)RuleEvaluationContextBuilder.DomainContexts.edgeCardinality(labels, this.edgeId, 0, EdgeCardinalityContext.Direction.INCOMING, Optional.of(CardinalityContext.Operation.ADD)));
                if (!DomainLookupFunctions.isValid(violations)) continue;
                result.add(definitionId);
            }
            return result;
        }
    }

    public static class LookupTargetRoles
    implements DomainLookupFunction {
        private final Node<? extends Definition<Object>, ? extends Edge> sourceNode;
        private final String edgeId;

        public LookupTargetRoles(Node<? extends Definition<Object>, ? extends Edge> sourceNode, String edgeId) {
            this.sourceNode = sourceNode;
            this.edgeId = edgeId;
        }

        @Override
        public Set<String> execute(DomainLookupContext context) {
            DomainLookupsCache cache = context.getCache();
            int outEdgeCount = DomainLookupFunctions.countOutgoingEdges(context, this.sourceNode, this.edgeId);
            RuleViolations outEdgeCardinalityResult = context.getRuleManager().evaluate(cache.getRuleSet(), (RuleEvaluationContext)RuleEvaluationContextBuilder.DomainContexts.edgeCardinality(this.sourceNode.getLabels(), this.edgeId, outEdgeCount, EdgeCardinalityContext.Direction.OUTGOING, Optional.of(CardinalityContext.Operation.ADD)));
            if (DomainLookupFunctions.isValid(outEdgeCardinalityResult)) {
                String defId = context.getDefinitionManager().adapters().forDefinition().getId(((Definition)this.sourceNode.getContent()).getDefinition()).value();
                return new LookupConnectionTargetRoles(this.edgeId, defId).execute(context);
            }
            return Collections.emptySet();
        }
    }

    public static interface DomainLookupFunction {
        public Set<String> execute(DomainLookupContext var1);
    }
}

