/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.backend.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.jboss.errai.bus.server.api.RpcContext;
import org.kie.workbench.common.stunner.core.backend.util.URLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;

@ApplicationScoped
public class BackendFileSystemManager {
    private static final Logger LOG = LoggerFactory.getLogger((String)BackendFileSystemManager.class.getName());
    public static final Charset UT8 = StandardCharsets.UTF_8;
    public static final String UT8_ENC = StandardCharsets.UTF_8.name();
    private static final FilenameFilter FILTER_NONE = (dir, name) -> true;
    private static final String WEBINF_PATH = "WEB-INF";
    private final IOService ioService;
    private final CommentedOptionFactory optionFactory;

    protected BackendFileSystemManager() {
        this(null, null);
    }

    @Inject
    public BackendFileSystemManager(@Named(value="ioStrategy") IOService ioService, CommentedOptionFactory optionFactory) {
        this.ioService = ioService;
        this.optionFactory = optionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(Path global, Assets assets, String message) {
        if (!this.ioService.exists(global)) {
            this.ioService.createDirectories(global, new FileAttribute[0]);
        }
        try {
            this.ioService.startBatch(global.getFileSystem());
            for (Asset asset : assets.assets) {
                int bytesRead;
                Path assetPath = global.resolve(asset.fileName);
                InputStream resource = asset.stream;
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                byte[] chunk = new byte[4096];
                while ((bytesRead = resource.read(chunk)) > 0) {
                    os.write(chunk, 0, bytesRead);
                }
                os.flush();
                resource.close();
                this.ioService.write(assetPath, os.toByteArray(), new OpenOption[]{this.optionFactory.makeCommentedOption(message)});
            }
        }
        catch (Exception e) {
            LOG.error("Error while deploying assets.", (Throwable)e);
        }
        finally {
            this.ioService.endBatch();
        }
    }

    public String getPathRelativeToApp(String path) {
        String wbp = null != path ? (path.trim().length() == 0 || ".".equals(path) ? WEBINF_PATH : "WEB-INF/" + path) : WEBINF_PATH;
        return RpcContext.getServletRequest().getServletContext().getRealPath(wbp).replaceAll("\\\\", "/");
    }

    public void findAndDeployFiles(File directory, Path targetPath) {
        this.findAndDeployFiles(directory, FILTER_NONE, targetPath);
    }

    public void findAndDeployFiles(File directory, FilenameFilter filter, Path targetPath) {
        File[] files = directory.listFiles(filter);
        if (files != null) {
            for (File f : files) {
                if (f.isFile()) {
                    this.registerIntoFileSystem(f, f.getName(), targetPath);
                    continue;
                }
                this.findAndDeployFiles(f, filter, targetPath.resolve(f.getName()));
            }
        }
    }

    private void registerIntoFileSystem(File file, String name, Path targetPath) {
        Path targetFilePath = targetPath.resolve(name);
        try {
            this.ioService.copy((InputStream)new FileInputStream(file), targetFilePath, new CopyOption[0]);
        }
        catch (Exception e) {
            LOG.error("Error writing file [" + name + "] into path [" + targetFilePath + "]", (Throwable)e);
        }
    }

    public IOService getIoService() {
        return this.ioService;
    }

    public static class Asset {
        private final String fileName;
        private final InputStream stream;

        private Asset(String fileName, InputStream stream) {
            this.fileName = fileName;
            this.stream = stream;
        }
    }

    public static class Assets {
        private final Collection<Asset> assets;

        public Assets(Collection<Asset> assets) {
            this.assets = assets;
        }

        public Assets add(Asset asset) {
            this.assets.add(asset);
            return this;
        }

        public Collection<Asset> getAssets() {
            return this.assets;
        }
    }

    public static class AssetBuilder {
        private String fileName;
        private InputStream stream;

        public AssetBuilder setFileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public AssetBuilder fromClasspathResouce(String resource) {
            this.stream = this.getClass().getClassLoader().getResourceAsStream(resource);
            return this;
        }

        public AssetBuilder fromString(String content) throws UnsupportedEncodingException {
            this.stream = AssetBuilder.toBytes(content);
            return this;
        }

        public AssetBuilder stringFromURI(String uri) throws IOException {
            this.stream = AssetBuilder.toBytes(URLUtils.readFromURL(uri));
            return this;
        }

        private static ByteArrayInputStream toBytes(String s) throws UnsupportedEncodingException {
            return new ByteArrayInputStream(s.getBytes(UT8_ENC));
        }

        public AssetBuilder binaryFromURI(String uri) throws IOException {
            this.stream = new ByteArrayInputStream(URLUtils.readBytesFromURL(uri));
            return this;
        }

        public Asset build() {
            return new Asset(this.fileName, this.stream);
        }
    }
}

