/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.services.backend.serialization.impl;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.apache.commons.lang3.StringUtils;
import org.kie.workbench.common.forms.model.FormModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormModelSerializer
implements JsonSerializer<FormModel>,
JsonDeserializer<FormModel> {
    private Logger log = LoggerFactory.getLogger(FormModelSerializer.class);

    public JsonElement serialize(FormModel formModel, Type type, JsonSerializationContext context) {
        JsonElement serializedModel = context.serialize((Object)formModel, formModel.getClass());
        serializedModel.getAsJsonObject().addProperty("formModelType", formModel.getClass().getName());
        return serializedModel;
    }

    public FormModel deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonField = json.getAsJsonObject();
        JsonElement jsonClassName = jsonField.get("formModelType");
        if (jsonClassName != null && !StringUtils.isEmpty((CharSequence)jsonClassName.getAsString())) {
            try {
                return (FormModel)context.deserialize(json, Class.forName(jsonClassName.getAsString()));
            }
            catch (Exception ex) {
                this.log.error("Error deserializing formModel", (Throwable)ex);
            }
        }
        return null;
    }
}

