/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties;

import java.util.Collections;
import java.util.List;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.ItemDefinition;
import org.eclipse.bpmn2.MultiInstanceLoopCharacteristics;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.ActivityPropertyReaderTest;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.MultipleInstanceActivityPropertyReader;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class MultipleInstanceActivityPropertyReaderTest {
    private static final String ITEM_ID = "ITEM_ID";
    private static final String PROPERTY_ID = "PROPERTY_ID";
    private static final String EXPRESSION = "EXPRESSION";
    private static final String DATA_TYPE = "java.lang.Object";
    private static final String DELIMITER = ":";
    private MultipleInstanceActivityPropertyReader reader;
    @Mock
    private Activity activity;
    @Mock
    private BPMNDiagram diagram;
    @Mock
    private DefinitionResolver definitionResolver;
    @Mock
    private MultiInstanceLoopCharacteristics miloop;

    @Before
    public void setUp() {
        this.reader = new MultipleInstanceActivityPropertyReader(this.activity, this.diagram, this.definitionResolver);
        Mockito.when((Object)this.activity.getLoopCharacteristics()).thenReturn((Object)this.miloop);
    }

    @Test
    public void testGetCollectionInput() {
        ItemAwareElement item = ActivityPropertyReaderTest.mockItemAwareElement(ITEM_ID);
        Mockito.when((Object)this.miloop.getLoopDataInputRef()).thenReturn((Object)item);
        List<DataInputAssociation> inputAssociations = Collections.singletonList(ActivityPropertyReaderTest.mockDataInputAssociation(ITEM_ID, PROPERTY_ID));
        Mockito.when((Object)this.activity.getDataInputAssociations()).thenReturn(inputAssociations);
        Assert.assertEquals((Object)PROPERTY_ID, (Object)this.reader.getCollectionInput());
    }

    @Test
    public void testGetDataInput() {
        DataInput item = ActivityPropertyReaderTest.mockDataInput(ITEM_ID, PROPERTY_ID);
        Mockito.when((Object)this.miloop.getInputDataItem()).thenReturn((Object)item);
        Assert.assertEquals((Object)"PROPERTY_ID:java.lang.Object", (Object)this.reader.getDataInput());
    }

    @Test
    public void testGetEmptyDataInput() {
        DataInput item = ActivityPropertyReaderTest.mockDataInput(ITEM_ID, null);
        Mockito.when((Object)this.miloop.getInputDataItem()).thenReturn((Object)item);
        Assert.assertEquals((Object)"ITEM_ID:java.lang.Object", (Object)this.reader.getDataInput());
    }

    @Test
    public void testGetEmptyDataOutput() {
        DataOutput item = ActivityPropertyReaderTest.mockDataOutput(ITEM_ID, null);
        Mockito.when((Object)this.miloop.getOutputDataItem()).thenReturn((Object)item);
        Assert.assertEquals((Object)"ITEM_ID:java.lang.Object", (Object)this.reader.getDataOutput());
    }

    @Test
    public void testGetCollectionOutput() {
        ItemAwareElement item = ActivityPropertyReaderTest.mockItemAwareElement(ITEM_ID);
        Mockito.when((Object)this.miloop.getLoopDataOutputRef()).thenReturn((Object)item);
        List<DataOutputAssociation> outputAssociations = Collections.singletonList(ActivityPropertyReaderTest.mockDataOutputAssociation(ITEM_ID, PROPERTY_ID));
        Mockito.when((Object)this.activity.getDataOutputAssociations()).thenReturn(outputAssociations);
        Assert.assertEquals((Object)PROPERTY_ID, (Object)this.reader.getCollectionOutput());
    }

    @Test
    public void testGetDataOutput() {
        DataOutput item = ActivityPropertyReaderTest.mockDataOutput(ITEM_ID, PROPERTY_ID);
        Mockito.when((Object)this.miloop.getOutputDataItem()).thenReturn((Object)item);
        Assert.assertEquals((Object)"PROPERTY_ID:java.lang.Object", (Object)this.reader.getDataOutput());
    }

    @Test
    public void testGetDataOutputForNullType() {
        DataOutput item = ActivityPropertyReaderTest.mockDataOutput(ITEM_ID, PROPERTY_ID);
        Mockito.when((Object)item.getItemSubjectRef()).thenReturn(null);
        Mockito.when((Object)this.miloop.getOutputDataItem()).thenReturn((Object)item);
        Assert.assertEquals((Object)"PROPERTY_ID:Object", (Object)this.reader.getDataOutput());
    }

    @Test
    public void testGetDataOutputForEmptyType() {
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        Mockito.when((Object)itemDefinition.getStructureRef()).thenReturn((Object)"");
        DataOutput item = ActivityPropertyReaderTest.mockDataOutput(ITEM_ID, PROPERTY_ID);
        Mockito.when((Object)item.getItemSubjectRef()).thenReturn((Object)itemDefinition);
        Mockito.when((Object)this.miloop.getOutputDataItem()).thenReturn((Object)item);
        Assert.assertEquals((Object)"PROPERTY_ID:Object", (Object)this.reader.getDataOutput());
    }

    @Test
    public void getGetCompletionCondition() {
        FormalExpression expression = (FormalExpression)Mockito.mock(FormalExpression.class);
        Mockito.when((Object)expression.getBody()).thenReturn((Object)EXPRESSION);
        Mockito.when((Object)this.miloop.getCompletionCondition()).thenReturn((Object)expression);
        Assert.assertEquals((Object)EXPRESSION, (Object)this.reader.getCompletionCondition());
    }

    @Test
    public void testGetIsSequentialTrue() {
        this.testIsSequential(true);
    }

    @Test
    public void testGetIsSequentialFalse() {
        this.testIsSequential(false);
    }

    private void testIsSequential(boolean sequential) {
        Mockito.when((Object)this.miloop.isIsSequential()).thenReturn((Object)sequential);
        Assert.assertEquals((Object)sequential, (Object)this.reader.isSequential());
    }
}

