/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.defaulteditor.backend.server;

import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.screens.defaulteditor.service.DefaultEditorContent;
import org.kie.workbench.common.screens.defaulteditor.service.DefaultEditorService;
import org.kie.workbench.common.services.backend.service.KieService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.backend.service.SaveAndRenameServiceImpl;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.ext.editor.commons.service.support.SupportsSaveAndRename;
import org.uberfire.java.nio.file.OpenOption;

@Service
@ApplicationScoped
public class DefaultEditorServiceImpl
extends KieService<DefaultEditorContent>
implements DefaultEditorService {
    @Inject
    CommentedOptionFactory commentedOptionFactory;
    @Inject
    SaveAndRenameServiceImpl<String, Metadata> saveAndRenameService;
    @Inject
    RenameService renameService;

    @PostConstruct
    public void init() {
        this.saveAndRenameService.init((SupportsSaveAndRename)this);
    }

    public DefaultEditorContent loadContent(Path path) {
        return (DefaultEditorContent)super.loadContent(path);
    }

    public Path save(Path resource, String content, Metadata metadata, String comment) {
        try {
            this.ioService.write(Paths.convert((Path)resource), content, this.metadataService.setUpAttributes(resource, metadata), new OpenOption[]{this.commentedOptionFactory.makeCommentedOption(comment)});
            return resource;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    protected DefaultEditorContent constructContent(Path path, Overview overview) {
        return new DefaultEditorContent(overview);
    }

    public Path rename(Path path, String newName, String comment) {
        return this.renameService.rename(path, newName, comment);
    }

    public Path saveAndRename(Path path, String newFileName, Metadata metadata, String content, String comment) {
        return this.saveAndRenameService.saveAndRename(path, newFileName, (Object)metadata, (Object)content, comment);
    }
}

