/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.coordination.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.MicroTime;
import io.fabric8.kubernetes.api.model.MicroTimeBuilder;
import io.fabric8.kubernetes.api.model.MicroTimeFluentImpl;
import io.fabric8.kubernetes.api.model.coordination.v1beta1.LeaseSpec;
import io.fabric8.kubernetes.api.model.coordination.v1beta1.LeaseSpecFluent;

public class LeaseSpecFluentImpl<A extends LeaseSpecFluent<A>>
extends BaseFluent<A>
implements LeaseSpecFluent<A> {
    private MicroTimeBuilder acquireTime;
    private String holderIdentity;
    private Integer leaseDurationSeconds;
    private Integer leaseTransitions;
    private MicroTimeBuilder renewTime;

    public LeaseSpecFluentImpl() {
    }

    public LeaseSpecFluentImpl(LeaseSpec instance) {
        this.withAcquireTime(instance.getAcquireTime());
        this.withHolderIdentity(instance.getHolderIdentity());
        this.withLeaseDurationSeconds(instance.getLeaseDurationSeconds());
        this.withLeaseTransitions(instance.getLeaseTransitions());
        this.withRenewTime(instance.getRenewTime());
    }

    @Override
    @Deprecated
    public MicroTime getAcquireTime() {
        return this.acquireTime != null ? this.acquireTime.build() : null;
    }

    @Override
    public MicroTime buildAcquireTime() {
        return this.acquireTime != null ? this.acquireTime.build() : null;
    }

    @Override
    public A withAcquireTime(MicroTime acquireTime) {
        this._visitables.get("acquireTime").remove(this.acquireTime);
        if (acquireTime != null) {
            this.acquireTime = new MicroTimeBuilder(acquireTime);
            this._visitables.get("acquireTime").add(this.acquireTime);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAcquireTime() {
        return this.acquireTime != null;
    }

    @Override
    public A withNewAcquireTime(String time) {
        return this.withAcquireTime(new MicroTime(time));
    }

    @Override
    public LeaseSpecFluent.AcquireTimeNested<A> withNewAcquireTime() {
        return new AcquireTimeNestedImpl();
    }

    @Override
    public LeaseSpecFluent.AcquireTimeNested<A> withNewAcquireTimeLike(MicroTime item) {
        return new AcquireTimeNestedImpl(item);
    }

    @Override
    public LeaseSpecFluent.AcquireTimeNested<A> editAcquireTime() {
        return this.withNewAcquireTimeLike(this.getAcquireTime());
    }

    @Override
    public LeaseSpecFluent.AcquireTimeNested<A> editOrNewAcquireTime() {
        return this.withNewAcquireTimeLike(this.getAcquireTime() != null ? this.getAcquireTime() : new MicroTimeBuilder().build());
    }

    @Override
    public LeaseSpecFluent.AcquireTimeNested<A> editOrNewAcquireTimeLike(MicroTime item) {
        return this.withNewAcquireTimeLike(this.getAcquireTime() != null ? this.getAcquireTime() : item);
    }

    @Override
    public String getHolderIdentity() {
        return this.holderIdentity;
    }

    @Override
    public A withHolderIdentity(String holderIdentity) {
        this.holderIdentity = holderIdentity;
        return (A)this;
    }

    @Override
    public Boolean hasHolderIdentity() {
        return this.holderIdentity != null;
    }

    @Override
    public A withNewHolderIdentity(String arg1) {
        return this.withHolderIdentity(new String(arg1));
    }

    @Override
    public A withNewHolderIdentity(StringBuilder arg1) {
        return this.withHolderIdentity(new String(arg1));
    }

    @Override
    public A withNewHolderIdentity(StringBuffer arg1) {
        return this.withHolderIdentity(new String(arg1));
    }

    @Override
    public Integer getLeaseDurationSeconds() {
        return this.leaseDurationSeconds;
    }

    @Override
    public A withLeaseDurationSeconds(Integer leaseDurationSeconds) {
        this.leaseDurationSeconds = leaseDurationSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasLeaseDurationSeconds() {
        return this.leaseDurationSeconds != null;
    }

    @Override
    public Integer getLeaseTransitions() {
        return this.leaseTransitions;
    }

    @Override
    public A withLeaseTransitions(Integer leaseTransitions) {
        this.leaseTransitions = leaseTransitions;
        return (A)this;
    }

    @Override
    public Boolean hasLeaseTransitions() {
        return this.leaseTransitions != null;
    }

    @Override
    @Deprecated
    public MicroTime getRenewTime() {
        return this.renewTime != null ? this.renewTime.build() : null;
    }

    @Override
    public MicroTime buildRenewTime() {
        return this.renewTime != null ? this.renewTime.build() : null;
    }

    @Override
    public A withRenewTime(MicroTime renewTime) {
        this._visitables.get("renewTime").remove(this.renewTime);
        if (renewTime != null) {
            this.renewTime = new MicroTimeBuilder(renewTime);
            this._visitables.get("renewTime").add(this.renewTime);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRenewTime() {
        return this.renewTime != null;
    }

    @Override
    public A withNewRenewTime(String time) {
        return this.withRenewTime(new MicroTime(time));
    }

    @Override
    public LeaseSpecFluent.RenewTimeNested<A> withNewRenewTime() {
        return new RenewTimeNestedImpl();
    }

    @Override
    public LeaseSpecFluent.RenewTimeNested<A> withNewRenewTimeLike(MicroTime item) {
        return new RenewTimeNestedImpl(item);
    }

    @Override
    public LeaseSpecFluent.RenewTimeNested<A> editRenewTime() {
        return this.withNewRenewTimeLike(this.getRenewTime());
    }

    @Override
    public LeaseSpecFluent.RenewTimeNested<A> editOrNewRenewTime() {
        return this.withNewRenewTimeLike(this.getRenewTime() != null ? this.getRenewTime() : new MicroTimeBuilder().build());
    }

    @Override
    public LeaseSpecFluent.RenewTimeNested<A> editOrNewRenewTimeLike(MicroTime item) {
        return this.withNewRenewTimeLike(this.getRenewTime() != null ? this.getRenewTime() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LeaseSpecFluentImpl that = (LeaseSpecFluentImpl)o;
        if (this.acquireTime != null ? !this.acquireTime.equals(that.acquireTime) : that.acquireTime != null) {
            return false;
        }
        if (this.holderIdentity != null ? !this.holderIdentity.equals(that.holderIdentity) : that.holderIdentity != null) {
            return false;
        }
        if (this.leaseDurationSeconds != null ? !this.leaseDurationSeconds.equals(that.leaseDurationSeconds) : that.leaseDurationSeconds != null) {
            return false;
        }
        if (this.leaseTransitions != null ? !this.leaseTransitions.equals(that.leaseTransitions) : that.leaseTransitions != null) {
            return false;
        }
        return !(this.renewTime != null ? !this.renewTime.equals(that.renewTime) : that.renewTime != null);
    }

    public class RenewTimeNestedImpl<N>
    extends MicroTimeFluentImpl<LeaseSpecFluent.RenewTimeNested<N>>
    implements LeaseSpecFluent.RenewTimeNested<N>,
    Nested<N> {
        private final MicroTimeBuilder builder;

        RenewTimeNestedImpl(MicroTime item) {
            this.builder = new MicroTimeBuilder(this, item);
        }

        RenewTimeNestedImpl() {
            this.builder = new MicroTimeBuilder(this);
        }

        @Override
        public N and() {
            return (N)LeaseSpecFluentImpl.this.withRenewTime(this.builder.build());
        }

        @Override
        public N endRenewTime() {
            return this.and();
        }
    }

    public class AcquireTimeNestedImpl<N>
    extends MicroTimeFluentImpl<LeaseSpecFluent.AcquireTimeNested<N>>
    implements LeaseSpecFluent.AcquireTimeNested<N>,
    Nested<N> {
        private final MicroTimeBuilder builder;

        AcquireTimeNestedImpl(MicroTime item) {
            this.builder = new MicroTimeBuilder(this, item);
        }

        AcquireTimeNestedImpl() {
            this.builder = new MicroTimeBuilder(this);
        }

        @Override
        public N and() {
            return (N)LeaseSpecFluentImpl.this.withAcquireTime(this.builder.build());
        }

        @Override
        public N endAcquireTime() {
            return this.and();
        }
    }
}

