/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.forms.validation.timerEditor;

import com.google.gwt.i18n.shared.DateTimeFormat;
import com.google.gwt.regexp.shared.MatchResult;
import com.google.gwt.regexp.shared.RegExp;
import java.util.ArrayList;
import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.kie.soup.commons.cron.CronExpression;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.timer.TimerSettingsValue;
import org.kie.workbench.common.stunner.bpmn.forms.validation.timerEditor.ValidTimerSettingsValue;

public class TimerSettingsValueValidator
implements ConstraintValidator<ValidTimerSettingsValue, TimerSettingsValue> {
    public static final String TimeDurationInvalid = "The timer duration must be a valid ISO-8601 duration or an expression like #{expression}.";
    public static final String ISOTimeCycleInvalid = "The timer cycle must be a valid ISO-8601 repeatable interval or an expression like #{expression}.";
    public static final String CronTimeCycleInvalid = "The time cycle must be a valid cron interval or an expression like #{expression}.";
    public static final String TimeDateInvalid = "The timer date must be a valid ISO-8601 date time or an expression like #{expression}.";
    public static final String NoValueHasBeenProvided = "At least one field must have a non empty value.";
    public static final String ISO = "none";
    public static final String CRON = "cron";
    public static final String DATE_PATTERN = "(\\d{4}-\\d{2}-\\d{2})";
    private static final String ISO_DURATION = "P(?!$)(\\d+Y)?(\\d+M)?(\\d+W)?(\\d+D)?(T(?=\\d)(\\d+H)?(\\d+M)?((\\d+((\\.|\\,)\\d+)?)+S)?)?";
    private static final String REPETITION_MASK = "R(\\d*)?";
    private static final String ISO_REPEATABLE_INTERVAL = "R(\\d*)?\\/P(?!$)(\\d+Y)?(\\d+M)?(\\d+W)?(\\d+D)?(T(?=\\d)(\\d+H)?(\\d+M)?((\\d+((\\.|\\,)\\d+)?)+S)?)?";
    private static final String ISO_DATE_TIME = "([\\+-]?\\d{4}(?!\\d{2}\\b))(-)(0[1-9]|1[0-2])(-)(0[1-9]|1[0-9]|2[0-9]|3[0-1])T(0[0-9]|1[0-9]|2[0-4])(:)([0-5][0-9])((:)[0-5][0-9]((.)[0-9][0-9][0-9])?)?(((((\\+)(0[0-9]|1[0-5]))|((\\-)(0[0-9]|1[0-8]))):([0-5][0-9]))|(Z))";
    private static final String ISO_REPEATABLE_DATE_TIME_INTERVAL = "R(\\d*)?\\/([\\+-]?\\d{4}(?!\\d{2}\\b))(-)(0[1-9]|1[0-2])(-)(0[1-9]|1[0-9]|2[0-9]|3[0-1])T(0[0-9]|1[0-9]|2[0-4])(:)([0-5][0-9])((:)[0-5][0-9]((.)[0-9][0-9][0-9])?)?(((((\\+)(0[0-9]|1[0-5]))|((\\-)(0[0-9]|1[0-8]))):([0-5][0-9]))|(Z))\\/P(?!$)(\\d+Y)?(\\d+M)?(\\d+W)?(\\d+D)?(T(?=\\d)(\\d+H)?(\\d+M)?((\\d+((\\.|\\,)\\d+)?)+S)?)?";
    private static final String ISO_REPEATABLE_START_END_INTERVAL = "R(\\d*)?\\/([\\+-]?\\d{4}(?!\\d{2}\\b))(-)(0[1-9]|1[0-2])(-)(0[1-9]|1[0-9]|2[0-9]|3[0-1])T(0[0-9]|1[0-9]|2[0-4])(:)([0-5][0-9])((:)[0-5][0-9]((.)[0-9][0-9][0-9])?)?(((((\\+)(0[0-9]|1[0-5]))|((\\-)(0[0-9]|1[0-8]))):([0-5][0-9]))|(Z))\\/([\\+-]?\\d{4}(?!\\d{2}\\b))(-)(0[1-9]|1[0-2])(-)(0[1-9]|1[0-9]|2[0-9]|3[0-1])T(0[0-9]|1[0-9]|2[0-4])(:)([0-5][0-9])((:)[0-5][0-9]((.)[0-9][0-9][0-9])?)?(((((\\+)(0[0-9]|1[0-5]))|((\\-)(0[0-9]|1[0-8]))):([0-5][0-9]))|(Z))";
    private static final String ISO_REPEATABLE_PERIOD_END_INTERVAL = "R(\\d*)?\\/P(?!$)(\\d+Y)?(\\d+M)?(\\d+W)?(\\d+D)?(T(?=\\d)(\\d+H)?(\\d+M)?((\\d+((\\.|\\,)\\d+)?)+S)?)?\\/([\\+-]?\\d{4}(?!\\d{2}\\b))(-)(0[1-9]|1[0-2])(-)(0[1-9]|1[0-9]|2[0-9]|3[0-1])T(0[0-9]|1[0-9]|2[0-4])(:)([0-5][0-9])((:)[0-5][0-9]((.)[0-9][0-9][0-9])?)?(((((\\+)(0[0-9]|1[0-5]))|((\\-)(0[0-9]|1[0-8]))):([0-5][0-9]))|(Z))";
    private static final String CRON_INTERVAL = "(\\d+)?(\\d+?d)?(\\s)?(\\d+?h)?(\\s)?(\\d+?m)?(\\s)?(\\d+?s)?(\\s)?(\\d+?ms)?";
    private static final String EXPRESSION = "#{(.+)}";
    private static final RegExp durationExpr = RegExp.compile((String)"^P(?!$)(\\d+Y)?(\\d+M)?(\\d+W)?(\\d+D)?(T(?=\\d)(\\d+H)?(\\d+M)?((\\d+((\\.|\\,)\\d+)?)+S)?)?$");
    private static final RegExp repeatableIntervalExpr = RegExp.compile((String)"^R(\\d*)?\\/P(?!$)(\\d+Y)?(\\d+M)?(\\d+W)?(\\d+D)?(T(?=\\d)(\\d+H)?(\\d+M)?((\\d+((\\.|\\,)\\d+)?)+S)?)?$");
    private static final RegExp cronIntervalExpr = RegExp.compile((String)"^(\\d+)?(\\d+?d)?(\\s)?(\\d+?h)?(\\s)?(\\d+?m)?(\\s)?(\\d+?s)?(\\s)?(\\d+?ms)?$");
    private static final RegExp expressionExpr = RegExp.compile((String)"^#{(.+)}$");
    private static final RegExp dateTimeExpr = RegExp.compile((String)"^([\\+-]?\\d{4}(?!\\d{2}\\b))(-)(0[1-9]|1[0-2])(-)(0[1-9]|1[0-9]|2[0-9]|3[0-1])T(0[0-9]|1[0-9]|2[0-4])(:)([0-5][0-9])((:)[0-5][0-9]((.)[0-9][0-9][0-9])?)?(((((\\+)(0[0-9]|1[0-5]))|((\\-)(0[0-9]|1[0-8]))):([0-5][0-9]))|(Z))$");
    private static final RegExp repeatableDateTimeExpr = RegExp.compile((String)"^R(\\d*)?\\/([\\+-]?\\d{4}(?!\\d{2}\\b))(-)(0[1-9]|1[0-2])(-)(0[1-9]|1[0-9]|2[0-9]|3[0-1])T(0[0-9]|1[0-9]|2[0-4])(:)([0-5][0-9])((:)[0-5][0-9]((.)[0-9][0-9][0-9])?)?(((((\\+)(0[0-9]|1[0-5]))|((\\-)(0[0-9]|1[0-8]))):([0-5][0-9]))|(Z))\\/P(?!$)(\\d+Y)?(\\d+M)?(\\d+W)?(\\d+D)?(T(?=\\d)(\\d+H)?(\\d+M)?((\\d+((\\.|\\,)\\d+)?)+S)?)?$");
    private static final RegExp repeatableStartEndExpr = RegExp.compile((String)"^R(\\d*)?\\/([\\+-]?\\d{4}(?!\\d{2}\\b))(-)(0[1-9]|1[0-2])(-)(0[1-9]|1[0-9]|2[0-9]|3[0-1])T(0[0-9]|1[0-9]|2[0-4])(:)([0-5][0-9])((:)[0-5][0-9]((.)[0-9][0-9][0-9])?)?(((((\\+)(0[0-9]|1[0-5]))|((\\-)(0[0-9]|1[0-8]))):([0-5][0-9]))|(Z))\\/([\\+-]?\\d{4}(?!\\d{2}\\b))(-)(0[1-9]|1[0-2])(-)(0[1-9]|1[0-9]|2[0-9]|3[0-1])T(0[0-9]|1[0-9]|2[0-4])(:)([0-5][0-9])((:)[0-5][0-9]((.)[0-9][0-9][0-9])?)?(((((\\+)(0[0-9]|1[0-5]))|((\\-)(0[0-9]|1[0-8]))):([0-5][0-9]))|(Z))$");
    private static final RegExp repeatablePeriodEndExpr = RegExp.compile((String)"^R(\\d*)?\\/P(?!$)(\\d+Y)?(\\d+M)?(\\d+W)?(\\d+D)?(T(?=\\d)(\\d+H)?(\\d+M)?((\\d+((\\.|\\,)\\d+)?)+S)?)?\\/([\\+-]?\\d{4}(?!\\d{2}\\b))(-)(0[1-9]|1[0-2])(-)(0[1-9]|1[0-9]|2[0-9]|3[0-1])T(0[0-9]|1[0-9]|2[0-4])(:)([0-5][0-9])((:)[0-5][0-9]((.)[0-9][0-9][0-9])?)?(((((\\+)(0[0-9]|1[0-5]))|((\\-)(0[0-9]|1[0-8]))):([0-5][0-9]))|(Z))$");
    private static final RegExp datePattern = RegExp.compile((String)"(\\d{4}-\\d{2}-\\d{2})", (String)"g");

    public void initialize(ValidTimerSettingsValue constraintAnnotation) {
    }

    public boolean isValid(TimerSettingsValue timerSettings, ConstraintValidatorContext constraintValidatorContext) {
        String errorMessage = null;
        if (timerSettings.getTimeDuration() != null) {
            String value = timerSettings.getTimeDuration();
            if (TimerSettingsValueValidator.looksLikeExpression(value) && !TimerSettingsValueValidator.isValidExpression(value) || !TimerSettingsValueValidator.looksLikeExpression(value) && !TimerSettingsValueValidator.isValidDuration(value)) {
                errorMessage = TimeDurationInvalid;
            }
        } else if (ISO.equals(timerSettings.getTimeCycleLanguage())) {
            String value = timerSettings.getTimeCycle();
            if (TimerSettingsValueValidator.looksLikeExpression(value) && !TimerSettingsValueValidator.isValidExpression(value) || !TimerSettingsValueValidator.looksLikeExpression(value) && !TimerSettingsValueValidator.isValidRepeatableInterval(value) && !TimerSettingsValueValidator.isValidRepeatableDateTimeInterval(value) && !TimerSettingsValueValidator.isValidRepeatableStartEndInterval(value) && !TimerSettingsValueValidator.isValidRepeatablePeriodEndInterval(value)) {
                errorMessage = ISOTimeCycleInvalid;
            }
        } else if (CRON.equals(timerSettings.getTimeCycleLanguage())) {
            String value = timerSettings.getTimeCycle();
            if (TimerSettingsValueValidator.looksLikeExpression(value) && !TimerSettingsValueValidator.isValidExpression(value) || !TimerSettingsValueValidator.looksLikeExpression(value) && !TimerSettingsValueValidator.isValidCronExpression(value)) {
                errorMessage = CronTimeCycleInvalid;
            }
        } else if (timerSettings.getTimeDate() != null) {
            String value = timerSettings.getTimeDate();
            if (TimerSettingsValueValidator.looksLikeExpression(value) && !TimerSettingsValueValidator.isValidExpression(value) || !TimerSettingsValueValidator.looksLikeExpression(value) && !TimerSettingsValueValidator.isValidTimeDate(value)) {
                errorMessage = TimeDateInvalid;
            }
        } else {
            errorMessage = NoValueHasBeenProvided;
        }
        if (errorMessage != null) {
            constraintValidatorContext.disableDefaultConstraintViolation();
            constraintValidatorContext.buildConstraintViolationWithTemplate(errorMessage).addConstraintViolation();
            return false;
        }
        return true;
    }

    private static boolean looksLikeExpression(String value) {
        return TimerSettingsValueValidator.hasSomething(value) && (value.startsWith("#{") || value.contains("{") || value.contains("}"));
    }

    private static boolean isValidExpression(String value) {
        return TimerSettingsValueValidator.hasSomething(value) && expressionExpr.test(value) && value.length() > 3;
    }

    private static boolean isValidDuration(String value) {
        return TimerSettingsValueValidator.hasSomething(value) && durationExpr.test(value);
    }

    private static boolean isValidRepeatableInterval(String value) {
        return TimerSettingsValueValidator.hasSomething(value) && repeatableIntervalExpr.test(value);
    }

    private static boolean isValidRepeatableDateTimeInterval(String value) {
        return TimerSettingsValueValidator.hasSomething(value) && repeatableDateTimeExpr.test(value) && TimerSettingsValueValidator.mayHaveValidDate(value);
    }

    private static boolean isValidRepeatableStartEndInterval(String value) {
        return TimerSettingsValueValidator.hasSomething(value) && repeatableStartEndExpr.test(value) && TimerSettingsValueValidator.mayHaveValidDate(value);
    }

    private static boolean isValidRepeatablePeriodEndInterval(String value) {
        return TimerSettingsValueValidator.hasSomething(value) && repeatablePeriodEndExpr.test(value) && TimerSettingsValueValidator.mayHaveValidDate(value);
    }

    private static boolean isValidCronExpression(String value) {
        return TimerSettingsValueValidator.isValidBPMNCronExpression(value) || TimerSettingsValueValidator.isValidQuartzExpression(value);
    }

    private static boolean isValidBPMNCronExpression(String value) {
        return TimerSettingsValueValidator.hasSomething(value) && cronIntervalExpr.test(value) && !value.endsWith(" ");
    }

    private static boolean isValidQuartzExpression(String value) {
        return TimerSettingsValueValidator.hasSomething(value) && CronExpression.isValidExpression((String)value);
    }

    private static boolean isValidTimeDate(String value) {
        return TimerSettingsValueValidator.hasSomething(value) && dateTimeExpr.test(value) && TimerSettingsValueValidator.mayHaveValidDate(value);
    }

    private static boolean hasSomething(String value) {
        return value != null && !value.trim().isEmpty();
    }

    private static List<String> fetchDateStrings(String value) {
        ArrayList<String> matches = new ArrayList<String>();
        MatchResult matcher = datePattern.exec(value);
        while (null != matcher) {
            matches.add(matcher.getGroup(1));
            matcher = datePattern.exec(value);
        }
        return matches;
    }

    private static boolean mayHaveValidDate(String value) {
        List<String> matches = TimerSettingsValueValidator.fetchDateStrings(value);
        if (!matches.isEmpty()) {
            try {
                DateTimeFormat dateTimeFormat = DateTimeFormat.getFormat((String)"yyyy-MM-dd");
                matches.forEach(arg_0 -> ((DateTimeFormat)dateTimeFormat).parseStrict(arg_0));
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return true;
    }
}

