/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.impl.storage;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.XStreamException;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;
import org.kie.server.controller.api.storage.KieServerTemplateStorage;
import org.kie.server.controller.impl.storage.ControllerStorageFileWatcher;
import org.kie.soup.xstream.XStreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedKieServerTemplateStorage
implements KieServerTemplateStorage {
    private static FileBasedKieServerTemplateStorage INSTANCE;
    public static final String STORAGE_FILE_WATCHER_ENABLED = "org.kie.server.controller.templatefile.watcher.enabled";
    public static final String SERVER_TEMPLATE_FILE_NAME_PROP = "org.kie.server.controller.templatefile";
    public static final String DEFAULT_SERVER_TEMPLATE_FILENAME;
    private static Logger logger;
    private Map<String, ServerTemplate> templateMap = new ConcurrentHashMap<String, ServerTemplate>();
    private Map<String, ServerTemplateKey> templateKeyMap = new ConcurrentHashMap<String, ServerTemplateKey>();
    private String templatesLocation;
    private XStream xstream;
    private boolean configWatcherEnabled = Boolean.parseBoolean(System.getProperty("org.kie.server.controller.templatefile.watcher.enabled", "false"));
    private ControllerStorageFileWatcher watcher;

    public static synchronized FileBasedKieServerTemplateStorage getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FileBasedKieServerTemplateStorage();
        }
        return INSTANCE;
    }

    public static synchronized FileBasedKieServerTemplateStorage getInstance(String templatesLocation) {
        if (INSTANCE == null) {
            INSTANCE = new FileBasedKieServerTemplateStorage(templatesLocation);
        }
        return INSTANCE;
    }

    protected FileBasedKieServerTemplateStorage() {
        this.init(null);
    }

    protected FileBasedKieServerTemplateStorage(String templatesLocation) {
        this.init(templatesLocation);
    }

    protected synchronized void init(String templatesLocation) {
        this.templateMap = new ConcurrentHashMap<String, ServerTemplate>();
        this.templateKeyMap = new ConcurrentHashMap<String, ServerTemplateKey>();
        this.xstream = XStreamUtils.createTrustingXStream();
        this.templatesLocation = templatesLocation != null && !templatesLocation.trim().isEmpty() ? templatesLocation : System.getProperty(SERVER_TEMPLATE_FILE_NAME_PROP, DEFAULT_SERVER_TEMPLATE_FILENAME);
        this.loadTemplateMapsFromFile();
        if (this.configWatcherEnabled) {
            this.watcher = new ControllerStorageFileWatcher(this.templatesLocation, this);
            Thread watcherThread = new Thread((Runnable)this.watcher, "Kie Controller File Storage Watch Thread");
            watcherThread.start();
        }
    }

    private synchronized void writeTemplateMap() {
        String xml = this.xstream.toXML(new ArrayList<ServerTemplate>(this.templateMap.values()));
        try {
            Files.write(Paths.get(this.templatesLocation, new String[0]), xml.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            logger.error("Unable to write template maps for standalone controller", (Throwable)e);
        }
    }

    public synchronized void loadTemplateMapsFromFile() {
        ArrayList templates = null;
        ConcurrentHashMap<String, ServerTemplate> newTemplateMap = new ConcurrentHashMap<String, ServerTemplate>();
        ConcurrentHashMap<String, ServerTemplateKey> newTemplateKeyMap = new ConcurrentHashMap<String, ServerTemplateKey>();
        try (FileReader reader = new FileReader(this.templatesLocation);){
            templates = (ArrayList)this.xstream.fromXML((Reader)reader);
            if (templates != null && !templates.isEmpty()) {
                templates.forEach(template -> {
                    newTemplateKeyMap.put(template.getId(), new ServerTemplateKey(template.getId(), template.getName()));
                    newTemplateMap.put(template.getId(), (ServerTemplate)template);
                });
            }
            this.templateKeyMap = newTemplateKeyMap;
            this.templateMap = newTemplateMap;
        }
        catch (FileNotFoundException e) {
            logger.warn("Unable to read server template maps from file {}. File does not exist.", (Object)this.templatesLocation);
            this.writeTemplateMap();
        }
        catch (XStreamException e) {
            logger.warn("Unable to read server template maps from file {}. File corrupted. Possible concurrent update in progress.", (Object)this.templatesLocation);
        }
        catch (Throwable e) {
            logger.error("Unable to read server template maps from file", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerTemplate store(ServerTemplate serverTemplate) {
        ServerTemplate template = null;
        Map<String, ServerTemplate> map = this.templateMap;
        synchronized (map) {
            this.templateKeyMap.put(serverTemplate.getId(), new ServerTemplateKey(serverTemplate.getId(), serverTemplate.getName()));
            template = this.templateMap.put(serverTemplate.getId(), serverTemplate);
            this.writeTemplateMap();
        }
        return template;
    }

    public List<ServerTemplateKey> loadKeys() {
        return new ArrayList<ServerTemplateKey>(this.templateKeyMap.values());
    }

    public ServerTemplateKey getTemplateKey(String id) {
        return this.templateKeyMap.get(id);
    }

    public List<ServerTemplate> load() {
        return new ArrayList<ServerTemplate>(this.templateMap.values());
    }

    public ServerTemplate load(String identifier) {
        return this.templateMap.get(identifier);
    }

    public boolean exists(String identifier) {
        return this.templateMap.containsKey(identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerTemplate update(ServerTemplate serverTemplate) {
        ServerTemplate updated = null;
        Map<String, ServerTemplate> map = this.templateMap;
        synchronized (map) {
            this.templateKeyMap.put(serverTemplate.getId(), new ServerTemplateKey(serverTemplate.getId(), serverTemplate.getName()));
            updated = this.templateMap.put(serverTemplate.getId(), serverTemplate);
            this.writeTemplateMap();
        }
        return updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerTemplate delete(String identifier) {
        ServerTemplate removed = null;
        Map<String, ServerTemplate> map = this.templateMap;
        synchronized (map) {
            this.templateKeyMap.remove(identifier);
            removed = this.templateMap.remove(identifier);
            this.writeTemplateMap();
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTemplateMaps() {
        Map<String, ServerTemplate> map = this.templateMap;
        synchronized (map) {
            this.templateKeyMap.entrySet().clear();
            this.templateMap.entrySet().clear();
        }
    }

    public void setTemplatesLocation(String templatesLocation) {
        this.templatesLocation = templatesLocation;
    }

    public String getTemplatesLocation() {
        return this.templatesLocation;
    }

    public String toString() {
        return "FileBasedKieServerTemplateStorage: { templatesLocation = " + this.templatesLocation + "}";
    }

    public void close() {
        if (this.watcher != null) {
            this.watcher.stop();
        }
    }

    static {
        DEFAULT_SERVER_TEMPLATE_FILENAME = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "template_store.xml";
        logger = LoggerFactory.getLogger(FileBasedKieServerTemplateStorage.class);
    }
}

