/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.artifacts;

import org.eclipse.bpmn2.DataObjectReference;
import org.eclipse.bpmn2.TextAnnotation;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.artifacts.ArtifactsConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.DataObjectPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.PropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.PropertyWriterFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.TextAnnotationPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.definition.DataObject;
import org.kie.workbench.common.stunner.bpmn.definition.property.artifacts.DataObjectType;
import org.kie.workbench.common.stunner.bpmn.definition.property.artifacts.DataObjectTypeValue;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.Name;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.impl.NodeImpl;
import org.kie.workbench.common.stunner.core.util.UUID;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ArtifactsConverterTest {
    public static final String NAME = "name";
    public static final String DOC = "doc";
    private ArtifactsConverter artifactsConverter;
    @Mock
    private PropertyWriterFactory propertyWriterFactory;
    private Node<View<org.kie.workbench.common.stunner.bpmn.definition.TextAnnotation>, ?> textAnnotationNode;
    private Node<View<DataObject>, ?> dataObjectNode;
    @Mock
    private View<org.kie.workbench.common.stunner.bpmn.definition.TextAnnotation> textAnnotationView;
    @Mock
    private View<DataObject> dataObjectView;
    @Mock
    private TextAnnotationPropertyWriter textAnnotationWriter;
    @Mock
    private DataObjectPropertyWriter dataObjectWriter;

    @Test
    public void toTextAnnotationElement() {
        org.kie.workbench.common.stunner.bpmn.definition.TextAnnotation textAnnotation = new org.kie.workbench.common.stunner.bpmn.definition.TextAnnotation();
        textAnnotation.getGeneral().getDocumentation().setValue(DOC);
        textAnnotation.getGeneral().getName().setValue(NAME);
        this.textAnnotationNode = new NodeImpl(UUID.uuid());
        this.textAnnotationNode.setContent(this.textAnnotationView);
        Mockito.when((Object)((org.kie.workbench.common.stunner.bpmn.definition.TextAnnotation)this.textAnnotationView.getDefinition())).thenReturn((Object)textAnnotation);
        Mockito.when((Object)this.propertyWriterFactory.of((TextAnnotation)ArgumentMatchers.any(TextAnnotation.class))).thenReturn((Object)this.textAnnotationWriter);
        this.artifactsConverter = new ArtifactsConverter(this.propertyWriterFactory);
        PropertyWriter propertyWriter = this.artifactsConverter.toElement((Node)((NodeImpl)this.textAnnotationNode));
        ((TextAnnotationPropertyWriter)Mockito.verify((Object)this.textAnnotationWriter)).setName(NAME);
        ((TextAnnotationPropertyWriter)Mockito.verify((Object)this.textAnnotationWriter)).setDocumentation(DOC);
        ((TextAnnotationPropertyWriter)Mockito.verify((Object)this.textAnnotationWriter)).setAbsoluteBounds(this.textAnnotationNode);
        Assert.assertEquals((Object)this.textAnnotationWriter, (Object)propertyWriter);
    }

    @Test
    public void toDataObjectElement() {
        DataObject dataObject = new DataObject();
        dataObject.getGeneral().getDocumentation().setValue(DOC);
        dataObject.setName(new Name(NAME));
        dataObject.setType(new DataObjectType(new DataObjectTypeValue(NAME)));
        this.dataObjectNode = new NodeImpl(UUID.uuid());
        this.dataObjectNode.setContent(this.dataObjectView);
        Mockito.when((Object)((DataObject)this.dataObjectView.getDefinition())).thenReturn((Object)dataObject);
        Mockito.when((Object)this.propertyWriterFactory.of((DataObjectReference)ArgumentMatchers.any(DataObjectReference.class))).thenReturn((Object)this.dataObjectWriter);
        this.artifactsConverter = new ArtifactsConverter(this.propertyWriterFactory);
        PropertyWriter propertyWriter = this.artifactsConverter.toElement((Node)((NodeImpl)this.dataObjectNode));
        ((DataObjectPropertyWriter)Mockito.verify((Object)this.dataObjectWriter)).setName(NAME);
        ((DataObjectPropertyWriter)Mockito.verify((Object)this.dataObjectWriter)).setType(NAME);
        ((DataObjectPropertyWriter)Mockito.verify((Object)this.dataObjectWriter)).setAbsoluteBounds(this.dataObjectNode);
        Assert.assertEquals((Object)this.dataObjectWriter, (Object)propertyWriter);
    }
}

