/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties;

import java.util.Collections;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomElement;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.SubProcessPropertyReader;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class EventSubprocessPropertyReaderTest {
    private DefinitionResolver definitionResolverReal;
    private SubProcessPropertyReader tested;

    @Before
    public void setUp() {
        Definitions definitions = Factories.bpmn2.createDefinitions();
        definitions.getRootElements().add(Factories.bpmn2.createProcess());
        BPMNDiagram bpmnDiagram = Factories.di.createBPMNDiagram();
        bpmnDiagram.setPlane(Factories.di.createBPMNPlane());
        definitions.getDiagrams().add(bpmnDiagram);
        this.definitionResolverReal = new DefinitionResolver(definitions, Collections.emptyList());
    }

    @Test
    public void testIsAsync() {
        SubProcess eventSubProcess = Factories.bpmn2.createSubProcess();
        CustomElement.async.of((BaseElement)eventSubProcess).set((Object)Boolean.TRUE);
        this.tested = new SubProcessPropertyReader(eventSubProcess, this.definitionResolverReal.getDiagram(), this.definitionResolverReal);
        Assert.assertTrue((boolean)this.tested.isAsync());
    }

    @Test
    public void testGetSlaDueDate() {
        String rawSlaDueDate = "12/25/1983";
        SubProcess eventSubProcess = Factories.bpmn2.createSubProcess();
        CustomElement.slaDueDate.of((BaseElement)eventSubProcess).set((Object)rawSlaDueDate);
        this.tested = new SubProcessPropertyReader(eventSubProcess, this.definitionResolverReal.getDiagram(), this.definitionResolverReal);
        Assert.assertTrue((boolean)this.tested.getSlaDueDate().contains(rawSlaDueDate));
    }
}

