/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.tasks;

import java.util.Arrays;
import java.util.stream.Stream;
import org.eclipse.bpmn2.BusinessRuleTask;
import org.eclipse.bpmn2.ManualTask;
import org.eclipse.bpmn2.ReceiveTask;
import org.eclipse.bpmn2.SendTask;
import org.eclipse.bpmn2.ServiceTask;
import org.eclipse.bpmn2.Task;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.converters.TypedFactoryManager;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomAttribute;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BpmnNode;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.BusinessRuleTaskPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.GenericServiceTaskPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.PropertyReaderFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.ServiceTaskPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.TaskPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.UserTaskPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.tasks.BaseTaskConverter;
import org.kie.workbench.common.stunner.bpmn.definition.GenericServiceTask;
import org.kie.workbench.common.stunner.bpmn.definition.NoneTask;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.BaseUserTaskExecutionSet;
import org.kie.workbench.common.stunner.bpmn.workitem.CustomTask;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.marshaller.MarshallingRequest;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;

public abstract class BaseTaskConverterTest {
    protected BaseTaskConverter tested;
    @Mock
    protected TypedFactoryManager factoryManager;
    @Mock
    protected PropertyReaderFactory propertyReaderFactory;
    @Mock
    protected View<org.kie.workbench.common.stunner.bpmn.definition.BusinessRuleTask> businessRuleTaskContent;
    @Mock
    protected View<NoneTask> noneTaskContent;
    protected NoneTask noneTaskDefinition;
    @Mock
    protected TaskPropertyReader taskPropertyReader;
    @Mock
    private Node<View<NoneTask>, Edge> noneTaskNode;
    @Mock
    private Node<View<CustomTask>, Edge> serviceTaskNode;
    @Mock
    private View<CustomTask> serviceTaskContent;
    @Mock
    protected View<GenericServiceTask> genericServiceTaskContent;
    @Mock
    private Node<View<org.kie.workbench.common.stunner.bpmn.definition.BusinessRuleTask>, Edge> businessRuleTaskNode;
    @Mock
    private Node<View<GenericServiceTask>, Edge> genericServiceTaskNode;
    @Mock
    private FeatureMap featureMap;
    @Mock
    private FeatureMap.Entry entry;

    @Before
    public void setUp() {
        this.noneTaskDefinition = new NoneTask();
        Mockito.when((Object)this.factoryManager.newNode((String)ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(NoneTask.class))).thenReturn(this.noneTaskNode);
        Mockito.when((Object)((View)this.noneTaskNode.getContent())).thenReturn(this.noneTaskContent);
        Mockito.when((Object)((NoneTask)this.noneTaskContent.getDefinition())).thenReturn((Object)this.noneTaskDefinition);
        Mockito.when((Object)this.entry.getEStructuralFeature()).thenReturn((Object)((EStructuralFeature)Mockito.mock(EStructuralFeature.class)));
        Mockito.when((Object)this.featureMap.stream()).thenReturn(Arrays.asList(this.entry).stream());
        this.tested = this.createTaskConverter();
    }

    protected BaseTaskConverter createTaskConverter() {
        return (BaseTaskConverter)Mockito.spy((Object)new BaseTaskConverter(this.factoryManager, this.propertyReaderFactory, MarshallingRequest.Mode.AUTO){

            protected Node<View, Edge> createNode(String id) {
                return null;
            }

            protected BaseUserTaskExecutionSet createUserTaskExecutionSet(UserTaskPropertyReader p) {
                return null;
            }
        });
    }

    @Test
    public void convertBusinessRuleTask() {
        BusinessRuleTask task = (BusinessRuleTask)Mockito.mock(BusinessRuleTask.class);
        BusinessRuleTaskPropertyReader propertyReader = (BusinessRuleTaskPropertyReader)Mockito.mock(BusinessRuleTaskPropertyReader.class);
        org.kie.workbench.common.stunner.bpmn.definition.BusinessRuleTask businessRuleDefinition = new org.kie.workbench.common.stunner.bpmn.definition.BusinessRuleTask();
        Mockito.when((Object)this.factoryManager.newNode((String)ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(org.kie.workbench.common.stunner.bpmn.definition.BusinessRuleTask.class))).thenReturn(this.businessRuleTaskNode);
        Mockito.when((Object)((View)this.businessRuleTaskNode.getContent())).thenReturn(this.businessRuleTaskContent);
        Mockito.when((Object)((org.kie.workbench.common.stunner.bpmn.definition.BusinessRuleTask)this.businessRuleTaskContent.getDefinition())).thenReturn((Object)businessRuleDefinition);
        Mockito.when((Object)this.propertyReaderFactory.of(task)).thenReturn((Object)propertyReader);
        BpmnNode converted = (BpmnNode)this.tested.convert((Task)task).value();
        Assert.assertNotEquals((Object)converted.value(), this.noneTaskNode);
        Assert.assertEquals((Object)converted.value(), this.businessRuleTaskNode);
    }

    @Test
    public void convertServiceTask() {
        ServiceTask task = (ServiceTask)Mockito.mock(ServiceTask.class);
        ServiceTaskPropertyReader serviceTaskPropertyReader = (ServiceTaskPropertyReader)Mockito.mock(ServiceTaskPropertyReader.class);
        CustomTask definition = new CustomTask();
        FeatureMap attributes = (FeatureMap)Mockito.mock(FeatureMap.class);
        FeatureMap.Entry ruleAttr = (FeatureMap.Entry)Mockito.mock(FeatureMap.Entry.class);
        EStructuralFeature ruleFeature = (EStructuralFeature)Mockito.mock(EStructuralFeature.class);
        Mockito.when((Object)this.factoryManager.newNode((String)ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(CustomTask.class))).thenReturn(this.serviceTaskNode);
        Mockito.when((Object)((View)this.serviceTaskNode.getContent())).thenReturn(this.serviceTaskContent);
        Mockito.when((Object)((CustomTask)this.serviceTaskContent.getDefinition())).thenReturn((Object)definition);
        Mockito.when((Object)this.propertyReaderFactory.ofCustom((Task)task)).thenReturn((Object)serviceTaskPropertyReader);
        Mockito.when((Object)task.getAnyAttribute()).thenReturn((Object)attributes);
        Mockito.when((Object)attributes.stream()).thenReturn(Stream.of(ruleAttr));
        Mockito.when((Object)ruleAttr.getEStructuralFeature()).thenReturn((Object)ruleFeature);
        Mockito.when((Object)ruleAttr.getValue()).thenReturn((Object)"");
        Mockito.when((Object)ruleFeature.getName()).thenReturn((Object)CustomAttribute.serviceImplementation.name());
        BpmnNode converted = (BpmnNode)this.tested.convert((Task)task).value();
        Assert.assertNotEquals((Object)converted.value(), this.noneTaskNode);
        Assert.assertEquals((Object)converted.value(), this.serviceTaskNode);
    }

    @Test
    public void convertGenericServiceTask() {
        ServiceTask task = (ServiceTask)Mockito.mock(ServiceTask.class);
        GenericServiceTaskPropertyReader genericServiceTaskPropertyReader = (GenericServiceTaskPropertyReader)Mockito.mock(GenericServiceTaskPropertyReader.class);
        GenericServiceTask definition = new GenericServiceTask();
        FeatureMap attributes = (FeatureMap)Mockito.mock(FeatureMap.class);
        FeatureMap.Entry ruleAttr = (FeatureMap.Entry)Mockito.mock(FeatureMap.Entry.class);
        EStructuralFeature ruleFeature = (EStructuralFeature)Mockito.mock(EStructuralFeature.class);
        Mockito.when((Object)this.factoryManager.newNode((String)ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(GenericServiceTask.class))).thenReturn(this.genericServiceTaskNode);
        Mockito.when((Object)((View)this.genericServiceTaskNode.getContent())).thenReturn(this.genericServiceTaskContent);
        Mockito.when((Object)((GenericServiceTask)this.genericServiceTaskContent.getDefinition())).thenReturn((Object)definition);
        Mockito.when((Object)this.propertyReaderFactory.of(task)).thenReturn((Object)genericServiceTaskPropertyReader);
        Mockito.when((Object)task.getAnyAttribute()).thenReturn((Object)attributes);
        Mockito.when((Object)attributes.stream()).thenReturn(Stream.of(ruleAttr));
        Mockito.when((Object)ruleAttr.getEStructuralFeature()).thenReturn((Object)ruleFeature);
        Mockito.when((Object)ruleAttr.getValue()).thenReturn((Object)"Java");
        Mockito.when((Object)ruleFeature.getName()).thenReturn((Object)CustomAttribute.serviceImplementation.name());
        BpmnNode converted = (BpmnNode)this.tested.convert((Task)task).value();
        Assert.assertNotEquals((Object)converted.value(), this.noneTaskNode);
        Assert.assertEquals((Object)converted.value(), this.genericServiceTaskNode);
    }

    @Test
    public void convertManualTask() {
        this.testTaskToNoneTask(ManualTask.class);
    }

    @Test
    public void convertReceiveTask() {
        this.testTaskToNoneTask(ReceiveTask.class);
    }

    @Test
    public void convertSendTask() {
        this.testTaskToNoneTask(SendTask.class);
    }

    @Test
    public void convertDefaultTask() {
        this.testTaskToNoneTask(Task.class);
    }

    private <T extends Task> void testTaskToNoneTask(Class<T> taskType) {
        Task task = (Task)Mockito.mock(taskType);
        Mockito.when((Object)task.getAnyAttribute()).thenReturn((Object)this.featureMap);
        Mockito.when((Object)this.propertyReaderFactory.of(task)).thenReturn((Object)this.taskPropertyReader);
        BpmnNode converted = (BpmnNode)this.tested.convert(task).value();
        Assert.assertEquals((Object)converted.value(), this.noneTaskNode);
    }
}

