/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.intermediate;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.intermediate.ThrowingIntermediateEventTest;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateCompensationEventThrowing;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.compensation.CompensationEventExecutionSet;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;

public class ThrowingIntermediateCompensationEventTest
extends ThrowingIntermediateEventTest<IntermediateCompensationEventThrowing> {
    private static final String BPMN_THROWING_INTERMEDIATE_EVENT_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/throwingIntermediateCompensationEvents.bpmn";
    private static final String EMPTY_TOP_LEVEL_EVENT_ID = "_1FA90A0E-DAB4-4667-A136-DA580CBFF039";
    private static final String FILLED_TOP_LEVEL_EVENT_ID = "_290C92D3-F521-471A-8EFE-BC4AD550AFD4";
    private static final String EMPTY_SUBPROCESS_LEVEL_EVENT_ID = "_D912D44D-C8AD-4094-B598-595E9FB95CA9";
    private static final String FILLED_SUBPROCESS_LEVEL_EVENT_ID = "_15715D7B-BCBB-4F31-9498-B5DF039BB55D";
    private static final String EMPTY_WITH_EDGES_TOP_LEVEL_EVENT_ID = "_1FBE977B-0DA6-44AB-920D-3C730AE99B6B";
    private static final String FILLED_WITH_EDGES_TOP_LEVEL_EVENT_ID = "_0C20130D-E5B6-4AD4-8F71-C4C09E200C7D";
    private static final String EMPTY_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID = "_2A9670B9-AD67-4674-96C7-332BF1DBE5AB";
    private static final String FILLED_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID = "_F00653FB-26FF-40DA-87D8-1D85AB15D190";
    private static final int AMOUNT_OF_NODES_IN_DIAGRAM = 23;
    private static final String DEFAULT_REFERENCE_ACTIVITY = null;

    @Override
    @Test
    public void testUnmarshallTopLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "Compensation event01 name\n ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "Compensation event01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String ACTIVITY_REFERENCE = "_1FDF93CC-5677-48C2-9760-B7B98FA08DD6";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateCompensationEventThrowing filledTopEvent = (IntermediateCompensationEventThrowing)this.getThrowingIntermediateNodeById(diagram, FILLED_TOP_LEVEL_EVENT_ID, false, 0);
        this.assertGeneralSet(filledTopEvent.getGeneral(), "Compensation event01 name\n ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Compensation event01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertCompensationEventExecutionSet(filledTopEvent.getExecutionSet(), "_1FDF93CC-5677-48C2-9760-B7B98FA08DD6");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEmptyEventProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateCompensationEventThrowing emptyTopEvent = (IntermediateCompensationEventThrowing)this.getThrowingIntermediateNodeById(diagram, EMPTY_TOP_LEVEL_EVENT_ID, false, 0);
        this.assertGeneralSet(emptyTopEvent.getGeneral(), "", "");
        this.assertCompensationEventExecutionSet(emptyTopEvent.getExecutionSet(), DEFAULT_REFERENCE_ACTIVITY);
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "Compensation event03 name\n ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "Compensation event03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String ACTIVITY_REFERENCE = "_4305E23D-496B-42AA-AEE0-2840B4E75F15";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateCompensationEventThrowing filledSubprocessEvent = (IntermediateCompensationEventThrowing)this.getThrowingIntermediateNodeById(diagram, FILLED_SUBPROCESS_LEVEL_EVENT_ID, false, 0);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "Compensation event03 name\n ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Compensation event03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertCompensationEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "_4305E23D-496B-42AA-AEE0-2840B4E75F15");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateCompensationEventThrowing emptySubprocessEvent = (IntermediateCompensationEventThrowing)this.getThrowingIntermediateNodeById(diagram, EMPTY_SUBPROCESS_LEVEL_EVENT_ID, false, 0);
        this.assertGeneralSet(emptySubprocessEvent.getGeneral(), "", "");
        this.assertCompensationEventExecutionSet(emptySubprocessEvent.getExecutionSet(), DEFAULT_REFERENCE_ACTIVITY);
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEventWithEdgesFilledProperties() {
        String EVENT_NAME = "Compensation event02 name\n ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "Compensation event02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String ACTIVITY_REFERENCE = "_1FDF93CC-5677-48C2-9760-B7B98FA08DD6";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateCompensationEventThrowing filledSubprocessEvent = (IntermediateCompensationEventThrowing)this.getThrowingIntermediateNodeById(diagram, FILLED_WITH_EDGES_TOP_LEVEL_EVENT_ID, true, 2);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "Compensation event02 name\n ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Compensation event02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertCompensationEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "_1FDF93CC-5677-48C2-9760-B7B98FA08DD6");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEventWithEdgesEmptyProperties() {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateCompensationEventThrowing emptyEvent = (IntermediateCompensationEventThrowing)this.getThrowingIntermediateNodeById(diagram, EMPTY_WITH_EDGES_TOP_LEVEL_EVENT_ID, true, 2);
        this.assertGeneralSet(emptyEvent.getGeneral(), "", "");
        this.assertCompensationEventExecutionSet(emptyEvent.getExecutionSet(), DEFAULT_REFERENCE_ACTIVITY);
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventWithEdgesEmptyProperties() {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateCompensationEventThrowing emptySubprocessEvent = (IntermediateCompensationEventThrowing)this.getThrowingIntermediateNodeById(diagram, EMPTY_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID, true, 2);
        this.assertGeneralSet(emptySubprocessEvent.getGeneral(), "", "");
        this.assertCompensationEventExecutionSet(emptySubprocessEvent.getExecutionSet(), DEFAULT_REFERENCE_ACTIVITY);
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventWithEdgesFilledProperties() {
        String EVENT_NAME = "Compensation event04 name\n ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "Compensation event04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String ACTIVITY_REFERENCE = "_4305E23D-496B-42AA-AEE0-2840B4E75F15";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateCompensationEventThrowing filledSubprocessEvent = (IntermediateCompensationEventThrowing)this.getThrowingIntermediateNodeById(diagram, FILLED_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID, true, 2);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "Compensation event04 name\n ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Compensation event04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertCompensationEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "_4305E23D-496B-42AA-AEE0-2840B4E75F15");
    }

    @Override
    String getBpmnThrowingIntermediateEventFilePath() {
        return BPMN_THROWING_INTERMEDIATE_EVENT_FILE_PATH;
    }

    @Override
    Class<IntermediateCompensationEventThrowing> getThrowingIntermediateEventType() {
        return IntermediateCompensationEventThrowing.class;
    }

    @Override
    String[] getFilledTopLevelEventIds() {
        return new String[]{FILLED_TOP_LEVEL_EVENT_ID};
    }

    @Override
    String getEmptyTopLevelEventId() {
        return EMPTY_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String[] getFilledSubprocessLevelEventIds() {
        return new String[]{FILLED_SUBPROCESS_LEVEL_EVENT_ID};
    }

    @Override
    String getEmptySubprocessLevelEventId() {
        return EMPTY_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String[] getFilledTopLevelEventWithEdgesIds() {
        return new String[]{FILLED_WITH_EDGES_TOP_LEVEL_EVENT_ID};
    }

    @Override
    String getEmptyTopLevelEventWithEdgesId() {
        return EMPTY_WITH_EDGES_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String[] getFilledSubprocessLevelEventWithEdgesIds() {
        return new String[]{FILLED_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID};
    }

    @Override
    String getEmptySubprocessLevelEventWithEdgesId() {
        return EMPTY_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID;
    }

    private void assertCompensationEventExecutionSet(CompensationEventExecutionSet executionSet, String activityReference) {
        Assertions.assertThat((Object)executionSet).isNotNull();
        Assertions.assertThat((Object)executionSet.getActivityRef()).isNotNull();
        Assertions.assertThat((String)executionSet.getActivityRef().getValue()).isEqualTo(activityReference);
    }
}

