/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.management;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.management.BaseHttpInterfaceResourceDefinition;
import org.jboss.as.controller.management.HttpInterfaceCommonPolicy;
import org.jboss.as.controller.management.ManagementInterfaceAddStepHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.jboss.remoting3.RemotingOptions;
import org.xnio.OptionMap;

public abstract class BaseHttpInterfaceAddStepHandler
extends ManagementInterfaceAddStepHandler {
    protected static final String SSL_CONTEXT_CAPABILITY = "org.wildfly.security.ssl-context";

    protected BaseHttpInterfaceAddStepHandler(AttributeDefinition[] attributeDefinitions) {
        super(attributeDefinitions);
    }

    @Override
    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        if (operation.hasDefined("http-upgrade-enabled")) {
            boolean httpUpgradeEnabled = operation.remove("http-upgrade-enabled").asBoolean();
            ModelNode httpUpgrade = operation.get("http-upgrade");
            if (httpUpgrade.hasDefined("enabled")) {
                boolean httpUpgradeDotEnabled = httpUpgrade.require("enabled").asBoolean();
                if (httpUpgradeEnabled != httpUpgradeDotEnabled) {
                    throw ControllerLogger.ROOT_LOGGER.deprecatedAndCurrentParameterMismatch("http-upgrade-enabled", "enabled");
                }
            } else {
                httpUpgrade.set("enabled", httpUpgradeEnabled);
            }
        }
        super.populateModel(operation, model);
    }

    @Override
    public void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        LinkedHashMap constantHeaders;
        String saslAuthenticationFactory;
        boolean httpUpgradeEnabled;
        final String httpAuthenticationFactory = this.asStringIfDefined(context, BaseHttpInterfaceResourceDefinition.HTTP_AUTHENTICATION_FACTORY, model);
        final String sslContext = this.asStringIfDefined(context, BaseHttpInterfaceResourceDefinition.SSL_CONTEXT, model);
        final boolean consoleEnabled = BaseHttpInterfaceResourceDefinition.CONSOLE_ENABLED.resolveModelAttribute(context, model).asBoolean();
        if (model.hasDefined("http-upgrade")) {
            ModelNode httpUpgrade = model.require("http-upgrade");
            httpUpgradeEnabled = BaseHttpInterfaceResourceDefinition.ENABLED.resolveModelAttribute(context, httpUpgrade).asBoolean();
            saslAuthenticationFactory = this.asStringIfDefined(context, BaseHttpInterfaceResourceDefinition.SASL_AUTHENTICATION_FACTORY, httpUpgrade);
        } else {
            httpUpgradeEnabled = false;
            saslAuthenticationFactory = null;
        }
        final List<String> allowedOrigins = BaseHttpInterfaceResourceDefinition.ALLOWED_ORIGINS.unwrap(context, model);
        String serverName = this.asStringIfDefined(context, BaseHttpInterfaceResourceDefinition.SERVER_NAME, model);
        OptionMap.Builder builder = OptionMap.builder();
        builder.set(RemotingOptions.SASL_PROTOCOL, (Object)BaseHttpInterfaceResourceDefinition.SASL_PROTOCOL.resolveModelAttribute(context, model).asString());
        if (serverName != null) {
            builder.set(RemotingOptions.SERVER_NAME, (Object)serverName);
        }
        final OptionMap options = builder.getMap();
        LinkedHashMap linkedHashMap = constantHeaders = model.hasDefined("constant-headers") ? new LinkedHashMap() : null;
        if (constantHeaders != null) {
            for (ModelNode headerMapping : model.require("constant-headers").asList()) {
                String path = BaseHttpInterfaceResourceDefinition.PATH.resolveModelAttribute(context, headerMapping).asString();
                ArrayList<HttpInterfaceCommonPolicy.Header> headers = new ArrayList<HttpInterfaceCommonPolicy.Header>();
                for (ModelNode header : headerMapping.require("headers").asList()) {
                    headers.add(new HttpInterfaceCommonPolicy.Header(BaseHttpInterfaceResourceDefinition.HEADER_NAME.resolveModelAttribute(context, header).asString(), BaseHttpInterfaceResourceDefinition.HEADER_VALUE.resolveModelAttribute(context, header).asString()));
                }
                if (constantHeaders.containsKey(path)) {
                    ((List)constantHeaders.get(path)).addAll(headers);
                    continue;
                }
                constantHeaders.put(path, headers);
            }
        }
        List<ServiceName> requiredServices = this.installServices(context, new HttpInterfaceCommonPolicy(){

            @Override
            public String getHttpAuthenticationFactory() {
                return httpAuthenticationFactory;
            }

            @Override
            public String getSSLContext() {
                return sslContext;
            }

            @Override
            public String getSaslAuthenticationFactory() {
                return saslAuthenticationFactory;
            }

            @Override
            public boolean isHttpUpgradeEnabled() {
                return httpUpgradeEnabled;
            }

            @Override
            public boolean isConsoleEnabled() {
                return consoleEnabled;
            }

            @Override
            public OptionMap getConnectorOptions() {
                return options;
            }

            @Override
            public List<String> getAllowedOrigins() {
                return allowedOrigins;
            }

            @Override
            public Map<String, List<HttpInterfaceCommonPolicy.Header>> getConstantHeaders() {
                return constantHeaders;
            }
        }, model);
        this.addVerifyInstallationStep(context, requiredServices);
    }

    protected abstract List<ServiceName> installServices(OperationContext var1, HttpInterfaceCommonPolicy var2, ModelNode var3) throws OperationFailedException;
}

