/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api.recursive.comparison;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FieldLocation
implements Comparable<FieldLocation> {
    private String fieldPath;

    @Override
    public int compareTo(FieldLocation other) {
        return this.fieldPath.compareTo(other.fieldPath);
    }

    public boolean equals(Object other) {
        if (!(other instanceof FieldLocation)) {
            return false;
        }
        FieldLocation castOther = (FieldLocation)other;
        return Objects.equals(this.fieldPath, castOther.fieldPath);
    }

    public int hashCode() {
        return Objects.hash(this.fieldPath);
    }

    public FieldLocation(String fieldPath) {
        Objects.requireNonNull(fieldPath, "a field path can't be null");
        this.fieldPath = fieldPath;
    }

    public String getFieldPath() {
        return this.fieldPath;
    }

    public String toString() {
        return String.format("FieldLocation [fieldPath=%s]", this.fieldPath);
    }

    public boolean matches(String concatenatedPath) {
        return this.fieldPath.equals(concatenatedPath);
    }

    static List<FieldLocation> from(String ... fieldPaths) {
        return Stream.of(fieldPaths).map(FieldLocation::new).collect(Collectors.toList());
    }

    public static FieldLocation fielLocation(String fieldPath) {
        return new FieldLocation(fieldPath);
    }
}

