/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.result;

import java.nio.ByteBuffer;
import org.mariadb.jdbc.internal.packet.result.AbstractResultPacket;
import org.mariadb.jdbc.internal.util.buffer.Reader;

public class EndOfFilePacket
extends AbstractResultPacket {
    private final byte packetSeq;
    private final short warningCount;
    private final short statusFlags;

    public EndOfFilePacket(ByteBuffer byteBuffer) {
        super(byteBuffer);
        Reader reader = new Reader(byteBuffer);
        this.packetSeq = 0;
        reader.readByte();
        this.warningCount = reader.readShort();
        this.statusFlags = reader.readShort();
    }

    @Override
    public AbstractResultPacket.ResultType getResultType() {
        return AbstractResultPacket.ResultType.EOF;
    }

    public byte getPacketSeq() {
        return this.packetSeq;
    }

    public short getWarningCount() {
        return this.warningCount;
    }

    public short getStatusFlags() {
        return this.statusFlags;
    }

    public String toString() {
        return "EndOfFilePacket{packetSeq=" + this.packetSeq + ", warningCount=" + this.warningCount + ", statusFlags=" + this.statusFlags + "}";
    }
}

