/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis.mcdc;

import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashSet;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.kie.dmn.model.api.DecisionTable;
import org.kie.dmn.model.api.InputClause;
import org.kie.dmn.validation.dtanalysis.mcdc.MCDCAnalyser;
import org.kie.dmn.validation.dtanalysis.mcdc.dmntck.ObjectFactory;
import org.kie.dmn.validation.dtanalysis.mcdc.dmntck.TestCases;

public class MCDC2TCKGenerator {
    public static String mcdc2tck(DecisionTable dt, List<MCDCAnalyser.PosNegBlock> selectedBlocks) throws JAXBException {
        ObjectFactory factory = new ObjectFactory();
        TestCases testCases = factory.createTestCases();
        LinkedHashSet<MCDCAnalyser.Record> mcdcRecords = new LinkedHashSet<MCDCAnalyser.Record>();
        int testCaseId = 1;
        for (MCDCAnalyser.PosNegBlock b : selectedBlocks) {
            boolean add = mcdcRecords.add(b.posRecord);
            if (add) {
                MCDC2TCKGenerator.appendRecordToTestCases(dt, testCases, String.valueOf(testCaseId), b.posRecord);
                ++testCaseId;
            }
            for (MCDCAnalyser.Record negRecord : b.negRecords) {
                add = mcdcRecords.add(negRecord);
                if (!add) continue;
                MCDC2TCKGenerator.appendRecordToTestCases(dt, testCases, String.valueOf(testCaseId), negRecord);
                ++testCaseId;
            }
        }
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{TestCases.class});
        Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
        jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
        StringWriter sw = new StringWriter();
        jaxbMarshaller.marshal((Object)testCases, (Writer)sw);
        return sw.toString();
    }

    private static void appendRecordToTestCases(DecisionTable dt, TestCases testCases, String withId, MCDCAnalyser.Record record) {
        ObjectFactory factory = new ObjectFactory();
        TestCases.TestCase testCase = factory.createTestCasesTestCase().withId("mcdc_" + withId).withName("Test case " + withId);
        testCase.withDescription(record.toString());
        for (int i = 0; i < record.enums.length; ++i) {
            Object en = record.enums[i];
            String inputName = ((InputClause)dt.getInput().get(i)).getInputExpression().getText();
            TestCases.TestCase.InputNode inputNode = factory.createTestCasesTestCaseInputNode().withName(inputName);
            testCase.withInputNode(inputNode);
            JAXBElement<Object> jaxbElement = factory.createValueTypeValue(en);
            inputNode.withValue((JAXBElement)jaxbElement);
        }
        if (record.output.size() != 1) {
            throw new UnsupportedOperationException();
        }
        Comparable<?> out = record.output.get(0);
        String outputName = dt.getOutputLabel();
        TestCases.TestCase.ResultNode resultNode = factory.createTestCasesTestCaseResultNode().withName(outputName);
        testCase.withResultNode(resultNode);
        JAXBElement<Object> jaxbElement = factory.createValueTypeValue(out);
        resultNode.withExpected(factory.createValueType().withValue(jaxbElement));
        testCases.withTestCase(testCase);
    }
}

