/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ssh.service.backend.editor;

import java.security.PublicKey;
import java.util.Collection;
import java.util.Date;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.ssh.service.backend.keystore.SSHKeyStore;
import org.uberfire.ssh.service.backend.keystore.SSHKeyStoreService;
import org.uberfire.ssh.service.backend.keystore.model.KeyMetaData;
import org.uberfire.ssh.service.backend.keystore.model.SSHPublicKey;
import org.uberfire.ssh.service.backend.keystore.util.PublicKeyConverter;
import org.uberfire.ssh.service.shared.editor.PortableSSHPublicKey;
import org.uberfire.ssh.service.shared.editor.SSHKeyEditorService;

@Service
@Dependent
public class SSHKeyEditorServiceImpl
implements SSHKeyEditorService {
    private SessionInfo sessionInfo;
    private SSHKeyStoreService keyStoreService;

    @Inject
    public SSHKeyEditorServiceImpl(SessionInfo sessionInfo, SSHKeyStoreService keyStoreService) {
        this.sessionInfo = sessionInfo;
        this.keyStoreService = keyStoreService;
    }

    public Collection<PortableSSHPublicKey> getUserKeys() {
        return this.keyStoreService.keyStore().getUserKeys(this.sessionInfo.getIdentity().getIdentifier()).stream().map(this::convert).collect(Collectors.toList());
    }

    public void deleteKey(PortableSSHPublicKey portableKey) {
        SSHKeyStore keyStore = this.keyStoreService.keyStore();
        Collection keys = keyStore.getUserKeys(this.sessionInfo.getIdentity().getIdentifier());
        keys.stream().filter(key -> key.getId().equals(portableKey.getId())).findAny().ifPresent(sshPublicKey -> keyStore.removeUserKey(this.sessionInfo.getIdentity().getIdentifier(), sshPublicKey));
    }

    public void addKey(String name, String keyContent) {
        this.keyStoreService.keyStore().addUserKey(this.sessionInfo.getIdentity().getIdentifier(), this.convert(name, keyContent));
    }

    private SSHPublicKey convert(String name, String keyContent) {
        try {
            return new SSHPublicKey(UUID.randomUUID().toString(), PublicKeyConverter.fromString((String)keyContent), new KeyMetaData(name, new Date()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private PortableSSHPublicKey convert(SSHPublicKey key) {
        return new PortableSSHPublicKey(key.getId(), key.getMetaData().getName(), PublicKeyConverter.fromPublicKey((PublicKey)key.getKey()), key.getMetaData().getCreationDate(), key.getMetaData().getLastTimeUsed());
    }
}

