/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.definition.adapter.binding;

import java.util.Collection;
import java.util.LinkedList;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionId;
import org.kie.workbench.common.stunner.core.registry.definition.AdapterRegistry;

public class BindableAdapterUtils {
    public static String getDefinitionId(Class<?> type) {
        return BindableAdapterUtils.getDefinitionId(type, null);
    }

    public static String getDefinitionId(Class<?> type, AdapterRegistry registry) {
        return BindableAdapterUtils.getGenericClassName(type);
    }

    public static String getDynamicDefinitionId(Class<?> type, String suffix) {
        return BindableAdapterUtils.getDynamicDefinitionId(BindableAdapterUtils.getDefinitionId(type), suffix);
    }

    public static String getDynamicDefinitionId(String typeId, String suffix) {
        return null != suffix ? DefinitionId.generateId(typeId, suffix) : typeId;
    }

    public static String getDynamicId(Class<?> type, String definitionId) {
        String gcn = BindableAdapterUtils.getGenericClassName(type);
        int gcnl = gcn.length();
        int dl = definitionId.length();
        return dl > gcnl + 1 ? definitionId.substring(gcnl + 1, dl) : null;
    }

    public static String getDefinitionSetId(Class<?> type) {
        return BindableAdapterUtils.getDefinitionSetId(type, null);
    }

    public static String getDefinitionSetDomain(Class<?> type) {
        String n = type.getName();
        return n.substring(0, n.lastIndexOf("."));
    }

    public static String getDefinitionSetId(Class<?> type, AdapterRegistry registry) {
        return BindableAdapterUtils.getGenericClassName(type);
    }

    public static String getPropertySetId(Class<?> type) {
        return BindableAdapterUtils.getPropertySetId(type, null);
    }

    public static String getPropertySetId(Class<?> type, DefinitionManager definitionManager) {
        return BindableAdapterUtils.getGenericClassName(type);
    }

    public static String getPropertyId(Class<?> type, DefinitionManager definitionManager) {
        return BindableAdapterUtils.getGenericClassName(type);
    }

    public static String getPropertyId(Class<?> type) {
        return BindableAdapterUtils.getPropertyId(type, null);
    }

    public static String getShapeSetId(Class<?> shapeSetClass) {
        return BindableAdapterUtils.getGenericClassName(shapeSetClass);
    }

    public static String getGenericClassName(Class<?> type) {
        return type.getName();
    }

    private static String getGenericClassId(Class<?> type) {
        return type.getSimpleName();
    }

    public static String toSimpleName(Object o) {
        String definitionId = BindableAdapterUtils.getDefinitionId(o.getClass());
        return definitionId.substring(definitionId.lastIndexOf(".") + 1, definitionId.length());
    }

    public static <T> Collection<Class<?>> toClassCollection(Iterable<T> source) {
        if (null != source && source.iterator().hasNext()) {
            LinkedList result = new LinkedList();
            for (T sourceObject : source) {
                result.add(sourceObject.getClass());
            }
            return result;
        }
        return null;
    }
}

