/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.editor.backend.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.kie.workbench.common.forms.editor.model.FormModelSynchronizationResult;
import org.kie.workbench.common.forms.editor.model.impl.FormModelSynchronizationResultImpl;
import org.kie.workbench.common.forms.editor.model.impl.TypeConflictImpl;
import org.kie.workbench.common.forms.editor.service.backend.FormModelHandler;
import org.kie.workbench.common.forms.model.FormModel;
import org.kie.workbench.common.forms.model.ModelProperty;
import org.kie.workbench.common.forms.service.backend.util.ModelPropertiesGenerator;
import org.kie.workbench.common.services.backend.project.ModuleClassLoaderHelper;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.uberfire.backend.vfs.Path;

public abstract class AbstractFormModelHandler<F extends FormModel>
implements FormModelHandler<F> {
    protected F formModel;
    protected Path path;
    protected ClassLoader projectClassLoader;
    protected KieModuleService moduleService;
    protected ModuleClassLoaderHelper classLoaderHelper;

    public AbstractFormModelHandler(KieModuleService moduleService, ModuleClassLoaderHelper classLoaderHelper) {
        this.moduleService = moduleService;
        this.classLoaderHelper = classLoaderHelper;
    }

    public void init(F formModel, Path path) {
        this.formModel = formModel;
        this.path = path;
        this.initClassLoader();
        this.initialize();
    }

    protected void initClassLoader() {
        this.projectClassLoader = this.classLoaderHelper.getModuleClassLoader((KieModule)this.moduleService.resolveModule(this.path));
    }

    protected abstract void initialize();

    public FormModelSynchronizationResult synchronizeFormModel() {
        this.checkInitialized();
        return this.synchronizeFormModelProperties(this.formModel, this.getCurrentModelProperties());
    }

    public FormModelSynchronizationResult synchronizeFormModelProperties(F formModel, List<ModelProperty> currentProperties) {
        FormModelSynchronizationResultImpl result = new FormModelSynchronizationResultImpl();
        List modelProperties = Optional.ofNullable(formModel.getProperties()).orElse(new ArrayList());
        result.setPreviousProperties(modelProperties);
        currentProperties.forEach(currentProperty -> {
            Optional<ModelProperty> optional = result.getPreviousProperties().stream().filter(oldProperty -> oldProperty.getName().equals(currentProperty.getName())).findFirst();
            if (optional.isPresent()) {
                ModelProperty oldProperty2 = optional.get();
                if (!oldProperty2.equals(currentProperty)) {
                    result.getConflicts().put(oldProperty2.getName(), new TypeConflictImpl(oldProperty2.getName(), oldProperty2.getTypeInfo(), currentProperty.getTypeInfo()));
                }
            } else {
                result.getNewProperties().add(currentProperty);
            }
        });
        modelProperties.forEach(oldProperty -> {
            Optional<ModelProperty> optional = currentProperties.stream().filter(currentProperty -> currentProperty.getName().equals(oldProperty.getName())).findFirst();
            if (!optional.isPresent()) {
                result.getRemovedProperties().add(oldProperty);
            }
        });
        formModel.getProperties().clear();
        formModel.getProperties().addAll(currentProperties);
        return result;
    }

    protected Optional<ModelProperty> createModelProperty(String name, String className, boolean isMultiple) {
        ModelProperty property = ModelPropertiesGenerator.createModelProperty((String)name, (String)className, (boolean)isMultiple, (ClassLoader)this.projectClassLoader);
        return Optional.ofNullable(property);
    }

    protected abstract void log(String var1, Exception var2);

    protected abstract List<ModelProperty> getCurrentModelProperties();

    public void checkInitialized() {
        if (this.path == null || this.formModel == null || this.projectClassLoader == null) {
            throw new IllegalStateException("Handler isn't initialized");
        }
    }
}

