/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.openshift.service;

import javax.inject.Inject;
import org.guvnor.ala.exceptions.RuntimeOperationException;
import org.guvnor.ala.openshift.access.OpenShiftAccessInterface;
import org.guvnor.ala.openshift.access.exceptions.OpenShiftClientException;
import org.guvnor.ala.openshift.model.OpenShiftRuntime;
import org.guvnor.ala.openshift.model.OpenShiftRuntimeState;
import org.guvnor.ala.registry.RuntimeRegistry;
import org.guvnor.ala.runtime.Runtime;
import org.guvnor.ala.runtime.RuntimeId;
import org.guvnor.ala.runtime.RuntimeManager;
import org.guvnor.ala.runtime.RuntimeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenShiftRuntimeManager
implements RuntimeManager {
    private final RuntimeRegistry runtimeRegistry;
    private final OpenShiftAccessInterface openshift;
    private static final Logger LOG = LoggerFactory.getLogger(OpenShiftRuntimeManager.class);

    @Inject
    public OpenShiftRuntimeManager(RuntimeRegistry runtimeRegistry, OpenShiftAccessInterface openshift) {
        this.runtimeRegistry = runtimeRegistry;
        this.openshift = openshift;
    }

    public boolean supports(RuntimeId runtimeId) {
        return runtimeId instanceof OpenShiftRuntime || this.runtimeRegistry.getRuntimeById(runtimeId.getId()) instanceof OpenShiftRuntime;
    }

    public void start(RuntimeId runtimeId) throws RuntimeOperationException {
        OpenShiftRuntime runtime = (OpenShiftRuntime)this.runtimeRegistry.getRuntimeById(runtimeId.getId());
        try {
            LOG.info("Starting runtime: " + runtimeId.getId());
            this.openshift.getOpenShiftClient(runtime.getProviderId()).start(runtime.getId());
            this.refresh(runtimeId);
            LOG.info("Started runtime: " + runtimeId.getId());
        }
        catch (OpenShiftClientException ex) {
            LOG.error("Error Starting runtime: " + runtimeId.getId(), (Throwable)ex);
            throw new RuntimeOperationException("Error Starting runtime: " + runtimeId.getId(), (Throwable)ex);
        }
    }

    public void stop(RuntimeId runtimeId) throws RuntimeOperationException {
        OpenShiftRuntime runtime = (OpenShiftRuntime)this.runtimeRegistry.getRuntimeById(runtimeId.getId());
        try {
            LOG.info("Stopping runtime: " + runtimeId.getId());
            this.openshift.getOpenShiftClient(runtime.getProviderId()).stop(runtime.getId());
            this.refresh(runtimeId);
            LOG.info("Stopped runtime: " + runtimeId.getId());
        }
        catch (OpenShiftClientException ex) {
            LOG.error("Error Stopping runtime: " + runtimeId.getId(), (Throwable)ex);
            throw new RuntimeOperationException("Error Stopping runtime: " + runtimeId.getId(), (Throwable)ex);
        }
    }

    public void restart(RuntimeId runtimeId) throws RuntimeOperationException {
        OpenShiftRuntime runtime = (OpenShiftRuntime)this.runtimeRegistry.getRuntimeById(runtimeId.getId());
        try {
            LOG.info("Restarting runtime: " + runtimeId.getId());
            this.openshift.getOpenShiftClient(runtime.getProviderId()).restart(runtime.getId());
            this.refresh(runtimeId);
            LOG.info("Restarted runtime: " + runtimeId.getId());
        }
        catch (OpenShiftClientException ex) {
            LOG.error("Error Restarting runtime: " + runtimeId.getId(), (Throwable)ex);
            throw new RuntimeOperationException("Error Restarting runtime: " + runtimeId.getId(), (Throwable)ex);
        }
    }

    public void refresh(RuntimeId runtimeId) throws RuntimeOperationException {
        OpenShiftRuntime runtime = (OpenShiftRuntime)this.runtimeRegistry.getRuntimeById(runtimeId.getId());
        if (runtime != null) {
            try {
                OpenShiftRuntimeState runtimeState = this.openshift.getOpenShiftClient(runtime.getProviderId()).getRuntimeState(runtime.getId());
                OpenShiftRuntime newRuntime = new OpenShiftRuntime(runtime.getId(), runtime.getName(), runtime.getConfig(), runtime.getProviderId(), runtime.getEndpoint(), runtime.getInfo(), (RuntimeState)runtimeState);
                this.runtimeRegistry.registerRuntime((Runtime)newRuntime);
            }
            catch (OpenShiftClientException ex) {
                LOG.error("Error Refreshing runtime: " + runtimeId.getId(), (Throwable)ex);
                throw new RuntimeOperationException("Error Refreshing runtime: " + runtimeId.getId(), (Throwable)ex);
            }
        }
    }

    public void pause(RuntimeId runtimeId) throws RuntimeOperationException {
        OpenShiftRuntime runtime = (OpenShiftRuntime)this.runtimeRegistry.getRuntimeById(runtimeId.getId());
        try {
            LOG.info("Pausing runtime: " + runtimeId.getId());
            this.openshift.getOpenShiftClient(runtime.getProviderId()).pause(runtime.getId());
            this.refresh(runtimeId);
            LOG.info("Paused runtime: " + runtimeId.getId());
        }
        catch (OpenShiftClientException ex) {
            LOG.error("Error Pausing runtime: " + runtimeId.getId(), (Throwable)ex);
            throw new RuntimeOperationException("Error Pausing runtime: " + runtimeId.getId(), (Throwable)ex);
        }
    }
}

