/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.backend.service.handler;

import org.kie.workbench.common.screens.datasource.management.backend.core.DataSourceRuntimeManager;
import org.kie.workbench.common.screens.datasource.management.backend.core.DeploymentOptions;
import org.kie.workbench.common.screens.datasource.management.backend.core.UnDeploymentOptions;
import org.kie.workbench.common.screens.datasource.management.backend.service.DataSourceServicesHelper;
import org.kie.workbench.common.screens.datasource.management.backend.service.DefChangeHandler;
import org.kie.workbench.common.screens.datasource.management.backend.service.DefResourceChangeObserver;
import org.kie.workbench.common.screens.datasource.management.events.DeleteDataSourceEvent;
import org.kie.workbench.common.screens.datasource.management.events.DeleteDriverEvent;
import org.kie.workbench.common.screens.datasource.management.events.NewDataSourceEvent;
import org.kie.workbench.common.screens.datasource.management.events.NewDriverEvent;
import org.kie.workbench.common.screens.datasource.management.events.UpdateDataSourceEvent;
import org.kie.workbench.common.screens.datasource.management.events.UpdateDriverEvent;
import org.kie.workbench.common.screens.datasource.management.model.DataSourceDef;
import org.kie.workbench.common.screens.datasource.management.model.DataSourceDeploymentInfo;
import org.kie.workbench.common.screens.datasource.management.model.Def;
import org.kie.workbench.common.screens.datasource.management.model.DriverDef;
import org.kie.workbench.common.screens.datasource.management.model.DriverDeploymentInfo;
import org.kie.workbench.common.screens.datasource.management.util.DataSourceDefSerializer;
import org.kie.workbench.common.screens.datasource.management.util.DataSourceEventHelper;
import org.kie.workbench.common.screens.datasource.management.util.DriverDefSerializer;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.io.IOService;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.ResourceChangeType;

public abstract class AbstractDefChangeHandler
implements DefChangeHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefResourceChangeObserver.class);
    protected DataSourceRuntimeManager runtimeManager;
    protected DataSourceServicesHelper serviceHelper;
    protected IOService ioService;
    protected KieModuleService moduleService;
    protected DataSourceEventHelper eventHelper;

    public AbstractDefChangeHandler() {
    }

    public AbstractDefChangeHandler(DataSourceRuntimeManager runtimeManager, DataSourceServicesHelper serviceHelper, IOService ioService, KieModuleService moduleService, DataSourceEventHelper eventHelper) {
        this.runtimeManager = runtimeManager;
        this.serviceHelper = serviceHelper;
        this.ioService = ioService;
        this.moduleService = moduleService;
        this.eventHelper = eventHelper;
    }

    @Override
    public void processResourceAdd(Path path, SessionInfo sessionInfo) {
        Def registeredDef;
        Def def = this.readDef(path);
        if (!(def == null || (registeredDef = (Def)this.serviceHelper.getDefRegistry().getEntry(path)) != null && registeredDef.equals((Object)def))) {
            this.updateDeployment(path, registeredDef, def, sessionInfo, ResourceChangeType.ADD);
        }
    }

    @Override
    public void processResourceUpdate(Path path, SessionInfo sessionInfo) {
        Def registeredDef;
        Def def = this.readDef(path);
        if (!(def == null || (registeredDef = (Def)this.serviceHelper.getDefRegistry().getEntry(path)) != null && registeredDef.equals((Object)def))) {
            this.updateDeployment(path, registeredDef, def, sessionInfo, ResourceChangeType.UPDATE);
        }
    }

    @Override
    public void processResourceRename(Path originalPath, Path targetPath, SessionInfo sessionInfo) {
        Def def = this.readDef(targetPath);
        if (def != null) {
            Def registeredDef;
            Def originalDef = (Def)this.serviceHelper.getDefRegistry().getEntry(originalPath);
            if (originalDef != null) {
                try {
                    this.serviceHelper.getDefRegistry().invalidateCache(originalPath);
                    this.unDeploy(originalDef);
                }
                catch (Exception e) {
                    logger.error("Un-deployment failure for file: " + originalPath, (Throwable)e);
                }
            }
            if ((registeredDef = (Def)this.serviceHelper.getDefRegistry().getEntry(targetPath)) == null || !registeredDef.equals((Object)def)) {
                this.updateDeployment(targetPath, registeredDef, def, sessionInfo, ResourceChangeType.RENAME);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processResourceDelete(Path path, SessionInfo sessionInfo) {
        Def registeredDef = (Def)this.serviceHelper.getDefRegistry().getEntry(path);
        if (registeredDef != null) {
            try {
                this.unDeploy(registeredDef);
            }
            catch (Exception e) {
                logger.error("Un-deployment failure for file: " + path, (Throwable)e);
            }
            finally {
                this.serviceHelper.getDefRegistry().invalidateCache(path);
                this.fireEvent(registeredDef, null, path, sessionInfo, ResourceChangeType.DELETE);
            }
        }
    }

    protected void updateDeployment(Path path, Def registeredDef, Def def, SessionInfo sessionInfo, ResourceChangeType changeType) {
        try {
            if (registeredDef != null) {
                this.unDeploy(registeredDef);
            }
            this.serviceHelper.getDefRegistry().invalidateCache(path);
            this.deploy(def);
            this.serviceHelper.getDefRegistry().setEntry(path, def);
            this.fireEvent(def, registeredDef, path, sessionInfo, changeType);
        }
        catch (Exception e) {
            logger.error("Deployment update failed for file: " + path, new Object[]{", registeredDef: " + registeredDef, " def: " + def, e});
        }
    }

    protected void unDeploy(Def def) throws Exception {
        if (def instanceof DataSourceDef) {
            DataSourceDeploymentInfo deploymentInfo = this.runtimeManager.getDataSourceDeploymentInfo(def.getUuid());
            if (deploymentInfo != null) {
                this.runtimeManager.unDeployDataSource(deploymentInfo, UnDeploymentOptions.forcedUnDeployment());
            }
        } else {
            DriverDeploymentInfo deploymentInfo = this.runtimeManager.getDriverDeploymentInfo(def.getUuid());
            if (deploymentInfo != null) {
                this.runtimeManager.unDeployDriver(deploymentInfo, UnDeploymentOptions.forcedUnDeployment());
            }
        }
    }

    protected void deploy(Def def) throws Exception {
        if (def instanceof DataSourceDef) {
            this.runtimeManager.deployDataSource((DataSourceDef)def, DeploymentOptions.create());
        } else {
            this.runtimeManager.deployDriver((DriverDef)def, DeploymentOptions.create());
        }
    }

    protected void fireEvent(Def def, Def originalDef, Path path, SessionInfo sessionInfo, ResourceChangeType changeType) {
        if (def instanceof DriverDef) {
            switch (changeType) {
                case ADD: {
                    this.eventHelper.fireCreateEvent(new NewDriverEvent((DriverDef)def, this.moduleService.resolveModule(path), this.getSessionId(sessionInfo), this.getIdentifier(sessionInfo)));
                    break;
                }
                case UPDATE: 
                case RENAME: {
                    this.eventHelper.fireUpdateEvent(new UpdateDriverEvent((DriverDef)def, this.moduleService.resolveModule(path), this.getSessionId(sessionInfo), this.getIdentifier(sessionInfo), (DriverDef)originalDef));
                    break;
                }
                case DELETE: {
                    this.eventHelper.fireDeleteEvent(new DeleteDriverEvent((DriverDef)def, this.moduleService.resolveModule(path), this.getSessionId(sessionInfo), this.getIdentifier(sessionInfo)));
                }
            }
        } else {
            switch (changeType) {
                case ADD: {
                    this.eventHelper.fireCreateEvent(new NewDataSourceEvent((DataSourceDef)def, this.moduleService.resolveModule(path), this.getSessionId(sessionInfo), this.getIdentifier(sessionInfo)));
                    break;
                }
                case UPDATE: 
                case RENAME: {
                    this.eventHelper.fireUpdateEvent(new UpdateDataSourceEvent((DataSourceDef)def, this.moduleService.resolveModule(path), this.getSessionId(sessionInfo), this.getIdentifier(sessionInfo), (DataSourceDef)originalDef));
                    break;
                }
                case DELETE: {
                    this.eventHelper.fireDeleteEvent(new DeleteDataSourceEvent((DataSourceDef)def, this.moduleService.resolveModule(path), this.getSessionId(sessionInfo), this.getIdentifier(sessionInfo)));
                }
            }
        }
    }

    private Def readDef(Path path) {
        Object def = null;
        try {
            def = this.serviceHelper.isDataSourceFile(path) ? DataSourceDefSerializer.deserialize(this.ioService.readAllString(Paths.convert((Path)path))) : DriverDefSerializer.deserialize(this.ioService.readAllString(Paths.convert((Path)path)));
        }
        catch (Exception e) {
            logger.error("It was not possible to deserialize content from file: " + path, (Throwable)e);
        }
        return def;
    }

    private String getSessionId(SessionInfo sessionInfo) {
        return sessionInfo != null ? sessionInfo.getId() : null;
    }

    private String getIdentifier(SessionInfo sessionInfo) {
        return sessionInfo != null && sessionInfo.getIdentity() != null ? sessionInfo.getIdentity().getIdentifier() : null;
    }
}

