/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.jbpm.server.service.impl;

import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.forms.editor.service.backend.FormModelHandler;
import org.kie.workbench.common.forms.editor.service.backend.SourceFormModelNotFoundException;
import org.kie.workbench.common.forms.jbpm.model.authoring.JBPMProcessModel;
import org.kie.workbench.common.forms.jbpm.model.authoring.task.TaskFormModel;
import org.kie.workbench.common.forms.jbpm.server.service.impl.AbstractJBPMFormModelHandler;
import org.kie.workbench.common.forms.jbpm.server.service.impl.BusinessProcessFormModelHandler;
import org.kie.workbench.common.forms.jbpm.service.shared.BPMFinderService;
import org.kie.workbench.common.forms.service.shared.FieldManager;
import org.kie.workbench.common.services.backend.project.ModuleClassLoaderHelper;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
public class TaskFormModelHandler
extends AbstractJBPMFormModelHandler<TaskFormModel> {
    private static final Logger logger = LoggerFactory.getLogger(BusinessProcessFormModelHandler.class);

    @Inject
    public TaskFormModelHandler(KieModuleService projectService, ModuleClassLoaderHelper classLoaderHelper, FieldManager fieldManager, BPMFinderService bpmFinderService) {
        super(projectService, classLoaderHelper, fieldManager, bpmFinderService);
    }

    public Class<TaskFormModel> getModelType() {
        return TaskFormModel.class;
    }

    public void checkSourceModel() throws SourceFormModelNotFoundException {
        JBPMProcessModel processModel = this.bpmFinderService.getModelForProcess(((TaskFormModel)this.formModel).getProcessId(), this.path);
        if (processModel != null) {
            Optional<TaskFormModel> optional = processModel.getTaskFormModels().stream().filter(taskFormModel -> taskFormModel.getFormName().equals(((TaskFormModel)this.formModel).getFormName())).findAny();
            if (!optional.isPresent()) {
                String[] params = new String[]{((TaskFormModel)this.formModel).getTaskName(), ((TaskFormModel)this.formModel).getProcessId()};
                throw new SourceFormModelNotFoundException("MissingTask.shortMessage", params, "MissingTask.fullMessage", params, "process", this.formModel);
            }
        } else {
            String[] params = new String[]{((TaskFormModel)this.formModel).getProcessId()};
            throw new SourceFormModelNotFoundException("MissingProcess.shortMessage", params, "MissingProcess.fullMessage", params, "process", this.formModel);
        }
    }

    public FormModelHandler<TaskFormModel> newInstance() {
        return new TaskFormModelHandler(this.moduleService, this.classLoaderHelper, this.fieldManager, this.bpmFinderService);
    }

    @Override
    protected TaskFormModel getSourceModel() {
        Optional<TaskFormModel> optional;
        JBPMProcessModel processModel = this.bpmFinderService.getModelForProcess(((TaskFormModel)this.formModel).getProcessId(), this.path);
        if (processModel != null && (optional = processModel.getTaskFormModels().stream().filter(taskFormModel -> taskFormModel.getFormName().equals(((TaskFormModel)this.formModel).getFormName())).findAny()).isPresent()) {
            return optional.get();
        }
        return null;
    }

    protected void log(String message, Exception e) {
        logger.warn(message, (Throwable)e);
    }
}

