/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.slack;

import com.github.seratch.jslack.Slack;
import com.github.seratch.jslack.api.methods.SlackApiException;
import com.github.seratch.jslack.api.methods.request.auth.AuthTestRequest;
import com.github.seratch.jslack.api.methods.request.channels.ChannelsListRequest;
import com.github.seratch.jslack.api.methods.request.chat.ChatPostMessageRequest;
import com.github.seratch.jslack.api.methods.request.reminders.RemindersAddRequest;
import com.github.seratch.jslack.api.methods.response.auth.AuthTestResponse;
import com.github.seratch.jslack.api.methods.response.channels.ChannelsListResponse;
import com.github.seratch.jslack.api.methods.response.chat.ChatPostMessageResponse;
import com.github.seratch.jslack.api.methods.response.reminders.RemindersAddResponse;
import java.io.IOException;

public class SlackAuth {
    private Slack slack = Slack.getInstance();

    public AuthTestResponse authBaseRequest(String accessToken) throws IllegalAccessError, IOException, SlackApiException {
        AuthTestResponse response = this.slack.methods().authTest(AuthTestRequest.builder().token(accessToken).build());
        if (!response.isOk()) {
            throw new IllegalAccessError("Error authenticating: " + response.getError());
        }
        return response;
    }

    public ChannelsListResponse authChannelListRequest(String accessToken) throws IllegalAccessError, IOException, SlackApiException {
        ChannelsListResponse channelListResponse = this.slack.methods().channelsList(ChannelsListRequest.builder().token(accessToken).build());
        if (!channelListResponse.isOk()) {
            throw new IllegalAccessError("Error authenticating channel list: " + channelListResponse.getError());
        }
        return channelListResponse;
    }

    public ChatPostMessageResponse authChatPostMessageRequest(String channelId, String accessToken, String message) throws IllegalAccessError, IOException, SlackApiException {
        ChatPostMessageResponse chatMessageResponse = this.slack.methods().chatPostMessage(ChatPostMessageRequest.builder().channel(channelId).token(accessToken).text(message).replyBroadcast(false).build());
        if (!chatMessageResponse.isOk()) {
            throw new IllegalAccessError("Error authenticating chat message: " + chatMessageResponse.getError());
        }
        return chatMessageResponse;
    }

    public RemindersAddResponse authAddReminderRequest(String accessToken, String reminderText, String time) throws IllegalAccessError, IOException, SlackApiException {
        RemindersAddResponse addReminderResponse = this.slack.methods().remindersAdd(RemindersAddRequest.builder().token(accessToken).text(reminderText).time(time).build());
        if (!addReminderResponse.isOk()) {
            throw new IllegalAccessError("Error authenticating add reminder message: " + addReminderResponse.getError());
        }
        return addReminderResponse;
    }

    public void setSlack(Slack slack) {
        this.slack = slack;
    }
}

