/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.api.preferences;

import org.kie.workbench.common.screens.library.api.preferences.VersionValidator;
import org.uberfire.preferences.shared.PropertyFormOptions;
import org.uberfire.preferences.shared.annotations.Property;
import org.uberfire.preferences.shared.annotations.WorkbenchPreference;
import org.uberfire.preferences.shared.bean.BasePreference;
import org.uberfire.preferences.shared.impl.validation.NotEmptyValidator;
import org.uberfire.preferences.shared.impl.validation.NumberPropertyValidator;

@WorkbenchPreference(identifier="LibraryProjectPreferences", bundleKey="LibraryProjectPreferences.Label")
public class LibraryProjectPreferences
implements BasePreference<LibraryProjectPreferences> {
    public static final String ASSETS_PER_PAGE_KEY = "org.kie.library.assets_per_page";
    public static final int ASSETS_PER_PAGE_VALUE = 15;
    @Property(bundleKey="LibraryProjectPreferences.Version", helpBundleKey="LibraryProjectPreferences.Version.Help", validators={NotEmptyValidator.class, VersionValidator.class})
    String version;
    @Property(bundleKey="LibraryProjectPreferences.Description", helpBundleKey="LibraryProjectPreferences.Description.Help")
    String description;
    @Property(bundleKey="LibraryProjectPreferences.Branch", helpBundleKey="LibraryProjectPreferences.Branch.Help", formOptions={PropertyFormOptions.DISABLED})
    String branch;
    @Property(bundleKey="LibraryProjectPreferences.AssetsPerPage", helpBundleKey="LibraryProjectPreferences.AssetsPerPage.Help", validators={NumberPropertyValidator.class})
    String assetsPerPage;

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public String getBranch() {
        return this.branch;
    }

    public int getAssetsPerPage() {
        String systemProperty = LibraryProjectPreferences.sdmSafeGetPropertyAssetsPerPage();
        int externalAssetsPerPage = 0;
        try {
            if (systemProperty.length() > 0) {
                externalAssetsPerPage = Integer.parseInt(systemProperty);
            }
            int n = externalAssetsPerPage = externalAssetsPerPage > 0 ? externalAssetsPerPage : 15;
            if (this.assetsPerPage != null && !this.assetsPerPage.isEmpty()) {
                return Integer.parseInt(this.assetsPerPage);
            }
            return externalAssetsPerPage;
        }
        catch (NumberFormatException e) {
            return externalAssetsPerPage;
        }
    }

    public static String sdmSafeGetPropertyAssetsPerPage() {
        String key = ASSETS_PER_PAGE_KEY;
        String def = String.valueOf(15);
        return System.getProperty(ASSETS_PER_PAGE_KEY, def);
    }
}

