/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Optional;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.fs.jgit.util.Git;

public class BlobAsInputStream {
    private static final Logger LOG = LoggerFactory.getLogger(BlobAsInputStream.class);
    private final Git git;
    private final String treeRef;
    private final String path;

    public BlobAsInputStream(Git git, String treeRef, String path) {
        this.git = git;
        this.treeRef = treeRef;
        this.path = path;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<InputStream> execute() {
        try (TreeWalk tw = new TreeWalk(this.git.getRepository());){
            block9: {
                ObjectId tree = this.git.getTreeFromRef(this.treeRef);
                tw.setFilter((TreeFilter)PathFilter.create((String)this.path));
                tw.reset((AnyObjectId)tree);
                while (tw.next()) {
                    if (tw.isSubtree() && !this.path.equals(tw.getPathString())) {
                        tw.enterSubtree();
                        continue;
                    }
                    break block9;
                }
                throw new NoSuchFileException("Can't find '" + this.path + "' in tree '" + this.treeRef + "'");
            }
            Optional<InputStream> optional = Optional.of(new ByteArrayInputStream(this.git.getRepository().open((AnyObjectId)tw.getObjectId(0), 3).getBytes()));
            return optional;
        }
        catch (Throwable t) {
            LOG.debug("Unexpected exception, this will trigger a NoSuchFileException.", t);
            throw new NoSuchFileException("Can't find '" + this.path + "' in tree '" + this.treeRef + "'");
        }
    }
}

