/*
 * Decompiled with CFR 0.152.
 */
package org.kie.provider.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.api.identity.UserImpl;
import org.kie.internal.identity.IdentityProvider;
import org.kie.provider.SessionInfoProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.rpc.impl.SessionInfoImpl;

@SessionScoped
public class SafeSessionInfoProvider
implements SessionInfoProvider,
Serializable {
    private static final long serialVersionUID = 8510219062936244657L;
    private static final Logger logger = LoggerFactory.getLogger(SafeSessionInfoProvider.class);
    @Inject
    private Instance<SessionInfo> delegate;
    @Inject
    private IdentityProvider identityProvider;

    @Override
    public String getId() {
        if (this.delegate.isUnsatisfied()) {
            return "--";
        }
        try {
            return ((SessionInfo)this.delegate.get()).getId();
        }
        catch (Exception e) {
            return "--";
        }
    }

    @Override
    public User getIdentity() {
        if (this.delegate.isUnsatisfied()) {
            return this.getUserFromIdentityProvider();
        }
        try {
            return ((SessionInfo)this.delegate.get()).getIdentity();
        }
        catch (Exception e) {
            logger.debug("SessionInfo bean was available but could not return identity: " + e.getMessage(), (Throwable)e);
            return this.getUserFromIdentityProvider();
        }
    }

    private User getUserFromIdentityProvider() {
        List roleStrList = this.identityProvider.getRoles();
        ArrayList<RoleImpl> roles = new ArrayList<RoleImpl>(roleStrList.size());
        for (String roleStr : roleStrList) {
            roles.add(new RoleImpl(roleStr));
        }
        return new UserImpl(this.identityProvider.getName(), roles);
    }

    @Override
    public SessionInfo getSessionInfo() {
        if (this.delegate.isUnsatisfied()) {
            return this.createSessionInfo();
        }
        try {
            SessionInfo sessionInfo = (SessionInfo)this.delegate.get();
            sessionInfo.getId();
            return sessionInfo;
        }
        catch (Exception e) {
            logger.debug("SessionInfo bean was available but could not be retrieved: " + e.getMessage(), (Throwable)e);
            return this.createSessionInfo();
        }
    }

    private SessionInfo createSessionInfo() {
        String id = this.getId();
        User identity = this.getUserFromIdentityProvider();
        return new SessionInfoImpl(id, identity);
    }
}

