/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.clustering.model;

import org.kie.pmml.api.enums.Named;
import org.kie.pmml.models.clustering.model.KiePMMLClusteringField;

public enum KiePMMLCompareFunction implements Named
{
    ABS_DIFF("absDiff"),
    GAUSS_SIM("gaussSim"),
    DELTA("delta"),
    EQUAL("equal"),
    TABLE("table");

    private final String name;
    private static final double NEGATIVE_LN_2;

    private KiePMMLCompareFunction(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public double apply(KiePMMLClusteringField field, double x, double y) {
        switch (this) {
            case ABS_DIFF: {
                return KiePMMLCompareFunction.absDiff(x, y);
            }
            case GAUSS_SIM: {
                return KiePMMLCompareFunction.gaussSim(x, y, field.getSimilarityScale().orElse(1.0));
            }
            case DELTA: {
                return KiePMMLCompareFunction.delta(x, y);
            }
            case EQUAL: {
                return KiePMMLCompareFunction.equal(x, y);
            }
            case TABLE: {
                throw new UnsupportedOperationException("\"table\" compare function not implemented");
            }
        }
        throw new IllegalStateException("Unknown compare function: " + (Object)((Object)this));
    }

    static double absDiff(double x, double y) {
        return Math.abs(x - y);
    }

    static double gaussSim(double x, double y, double similarityScale) {
        return Math.exp(NEGATIVE_LN_2 * Math.pow(x - y, 2.0) / Math.pow(similarityScale, 2.0));
    }

    static double delta(double x, double y) {
        return KiePMMLCompareFunction.doubleEquals(x, y) ? 0.0 : 1.0;
    }

    static double equal(double x, double y) {
        return KiePMMLCompareFunction.doubleEquals(x, y) ? 1.0 : 0.0;
    }

    private static boolean doubleEquals(double x, double y) {
        return Double.compare(x, y) == 0;
    }

    static {
        NEGATIVE_LN_2 = -1.0 * Math.log(2.0);
    }
}

