/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.organizationalunit;

import java.util.ArrayList;
import java.util.Collection;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitSearchService;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.jboss.errai.bus.server.annotations.Service;

@Service
@ApplicationScoped
public class OrganizationalUnitSearchServiceImpl
implements OrganizationalUnitSearchService {
    private OrganizationalUnitService organizationalUnitService;

    @Inject
    public OrganizationalUnitSearchServiceImpl(OrganizationalUnitService organizationalUnitService) {
        this.organizationalUnitService = organizationalUnitService;
    }

    public Collection<OrganizationalUnit> searchByName(String pattern, int maxItems, boolean caseSensitive) {
        ArrayList<OrganizationalUnit> results = new ArrayList<OrganizationalUnit>();
        for (OrganizationalUnit unit : this.organizationalUnitService.getAllOrganizationalUnits()) {
            String name = unit.getName();
            if (!(caseSensitive ? name.contains(pattern) : name.toLowerCase().contains(pattern.toLowerCase()))) continue;
            results.add(unit);
            if (maxItems <= 0 || results.size() < maxItems) continue;
            return results;
        }
        return results;
    }

    public Collection<OrganizationalUnit> searchById(Collection<String> ids) {
        ArrayList<OrganizationalUnit> results = new ArrayList<OrganizationalUnit>();
        for (OrganizationalUnit unit : this.organizationalUnitService.getAllOrganizationalUnits()) {
            if (!ids.contains(unit.getIdentifier())) continue;
            results.add(unit);
        }
        return results;
    }
}

