/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.mining.compiler.factories;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.compiler.api.dto.CompilationDTO;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLModelFactoryUtils;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.models.mining.compiler.dto.MiningModelCompilationDTO;
import org.kie.pmml.models.mining.compiler.factories.KiePMMLSegmentationFactory;
import org.kie.pmml.models.mining.model.KiePMMLMiningModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLMiningModelFactory {
    static final String KIE_PMML_MINING_MODEL_TEMPLATE_JAVA = "KiePMMLMiningModelTemplate.tmpl";
    static final String KIE_PMML_MINING_MODEL_TEMPLATE = "KiePMMLMiningModelTemplate";
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLMiningModelFactory.class.getName());

    private KiePMMLMiningModelFactory() {
    }

    public static KiePMMLMiningModel getKiePMMLMiningModel(MiningModelCompilationDTO compilationDTO) {
        logger.debug("getKiePMMLMiningModel {}", (Object)compilationDTO.getModel());
        ArrayList<KiePMMLModel> nestedModels = new ArrayList<KiePMMLModel>();
        Map<String, String> sourcesMap = KiePMMLMiningModelFactory.getKiePMMLMiningModelSourcesMapCompiled(compilationDTO, nestedModels);
        try {
            Class kiePMMLMiningModel = compilationDTO.compileAndLoadClass(sourcesMap);
            return (KiePMMLMiningModel)kiePMMLMiningModel.newInstance();
        }
        catch (Exception e) {
            throw new KiePMMLException((Throwable)e);
        }
    }

    public static Map<String, String> getKiePMMLMiningModelSourcesMap(MiningModelCompilationDTO compilationDTO, List<KiePMMLModel> nestedModels) {
        logger.trace("getKiePMMLMiningModelSourcesMap {} {} {}", new Object[]{compilationDTO.getFields(), compilationDTO.getModel(), compilationDTO.getPackageName()});
        Map<String, String> toReturn = KiePMMLSegmentationFactory.getSegmentationSourcesMap(compilationDTO, nestedModels);
        return KiePMMLMiningModelFactory.getKiePMMLMiningModelSourcesMapCommon(compilationDTO, toReturn);
    }

    public static Map<String, String> getKiePMMLMiningModelSourcesMapCompiled(MiningModelCompilationDTO compilationDTO, List<KiePMMLModel> nestedModels) {
        logger.trace("getKiePMMLMiningModelSourcesMapCompiled {} {} {}", new Object[]{compilationDTO.getFields(), compilationDTO.getModel(), compilationDTO.getPackageName()});
        Map<String, String> toReturn = KiePMMLSegmentationFactory.getSegmentationSourcesMapCompiled(compilationDTO, nestedModels);
        return KiePMMLMiningModelFactory.getKiePMMLMiningModelSourcesMapCommon(compilationDTO, toReturn);
    }

    static Map<String, String> getKiePMMLMiningModelSourcesMapCommon(MiningModelCompilationDTO compilationDTO, Map<String, String> toReturn) {
        logger.trace("getKiePMMLMiningModelSourcesMap {} {} {}", new Object[]{compilationDTO.getFields(), compilationDTO.getModel(), compilationDTO.getPackageName()});
        if (!toReturn.containsKey(compilationDTO.getSegmentationCanonicalClassName())) {
            throw new KiePMMLException("Expected generated class " + compilationDTO.getSegmentationCanonicalClassName() + " not found");
        }
        CompilationUnit cloneCU = JavaParserUtils.getKiePMMLModelCompilationUnit((String)compilationDTO.getSimpleClassName(), (String)compilationDTO.getPackageName(), (String)KIE_PMML_MINING_MODEL_TEMPLATE_JAVA, (String)KIE_PMML_MINING_MODEL_TEMPLATE);
        ClassOrInterfaceDeclaration modelTemplate = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(compilationDTO.getSimpleClassName()).orElseThrow(() -> new KiePMMLException("Main class not found: " + compilationDTO.getSimpleClassName()));
        KiePMMLMiningModelFactory.setConstructor(compilationDTO, modelTemplate);
        toReturn.put(JavaParserUtils.getFullClassName((CompilationUnit)cloneCU), cloneCU.toString());
        return toReturn;
    }

    static void setConstructor(MiningModelCompilationDTO compilationDTO, ClassOrInterfaceDeclaration modelTemplate) {
        KiePMMLModelFactoryUtils.init((CompilationDTO)compilationDTO, (ClassOrInterfaceDeclaration)modelTemplate);
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)modelTemplate.getDefaultConstructor().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing default constructor in ClassOrInterfaceDeclaration %s ", modelTemplate.getName())));
        BlockStmt body = constructorDeclaration.getBody();
        ClassOrInterfaceType kiePMMLSegmentationClass = StaticJavaParser.parseClassOrInterfaceType((String)compilationDTO.getSegmentationCanonicalClassName());
        ObjectCreationExpr objectCreationExpr = new ObjectCreationExpr();
        objectCreationExpr.setType(kiePMMLSegmentationClass);
        CommonCodegenUtils.setAssignExpressionValue((BlockStmt)body, (String)"segmentation", (Expression)objectCreationExpr);
    }
}

