/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtree.backend.server;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.drools.workbench.models.guided.dtree.shared.model.GuidedDecisionTree;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.ActionInsertNode;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.Node;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.TypeNode;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.soup.project.datamodel.imports.Import;
import org.kie.soup.project.datamodel.imports.Imports;

public class GuidedDecisionTreeModelVisitor {
    private final GuidedDecisionTree model;
    private final String packageName;
    private final Imports imports;

    public GuidedDecisionTreeModelVisitor(GuidedDecisionTree model) {
        this.model = (GuidedDecisionTree)PortablePreconditions.checkNotNull((String)"model", (Object)model);
        this.packageName = model.getPackageName();
        this.imports = model.getImports();
    }

    public Set<String> getConsumedModelClasses() {
        HashSet<String> factTypes = new HashSet<String>();
        factTypes.addAll(this.visitNode((Node)this.model.getRoot()));
        HashSet<String> fullyQualifiedClassNames = new HashSet<String>();
        for (String factType : factTypes) {
            fullyQualifiedClassNames.add(this.convertToFullyQualifiedClassName(factType));
        }
        return fullyQualifiedClassNames;
    }

    private Set<String> visitNode(Node node) {
        if (node == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> factTypes = new HashSet<String>();
        if (node instanceof TypeNode) {
            TypeNode tn = (TypeNode)node;
            factTypes.add(tn.getClassName());
        } else if (node instanceof ActionInsertNode) {
            ActionInsertNode an = (ActionInsertNode)node;
            factTypes.add(an.getClassName());
        }
        for (Node child : node.getChildren()) {
            factTypes.addAll(this.visitNode(child));
        }
        return factTypes;
    }

    private String convertToFullyQualifiedClassName(String factType) {
        if (factType.contains(".")) {
            return factType;
        }
        String fullyQualifiedClassName = null;
        for (Import imp : this.imports.getImports()) {
            if (!imp.getType().endsWith(factType)) continue;
            fullyQualifiedClassName = imp.getType();
            break;
        }
        if (fullyQualifiedClassName == null) {
            fullyQualifiedClassName = this.packageName + "." + factType;
        }
        return fullyQualifiedClassName;
    }
}

