/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.backend.integration.wildfly;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.kie.workbench.common.screens.datasource.management.backend.integration.wildfly.WildflyBaseClient;

public class WildflyDeploymentClient
extends WildflyBaseClient {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployContent(String deploymentName, String runtimeName, byte[] content, boolean enabled) throws Exception {
        ModelControllerClient client = null;
        ModelNode response = null;
        try {
            client = this.createControllerClient();
            ModelNode operation = new ModelNode();
            operation.get("operation").set("add");
            operation.get("address").add("deployment", deploymentName);
            ArrayList<ModelNode> contentList = new ArrayList<ModelNode>();
            ModelNode contentNode = new ModelNode();
            contentNode.set("bytes", content);
            contentList.add(contentNode);
            operation.get("name").set(deploymentName);
            operation.get("content").set(contentList);
            operation.get("enabled").set(enabled);
            operation.get("runtime-name").set(runtimeName);
            response = client.execute(operation);
            if (!this.isFailure(response) && this.serverGroup != null) {
                operation = new ModelNode();
                operation.get("operation").set("add");
                operation.get("address").add("datasource.management.wildfly.serverGroup", this.serverGroup);
                operation.get("address").add("deployment", deploymentName);
                operation.get("name").set(deploymentName);
                operation.get("enabled").set(enabled);
                operation.get("runtime-name").set(runtimeName);
                response = client.execute(operation);
            }
        }
        catch (Throwable throwable) {
            this.safeClose((Closeable)client);
            this.checkResponse(response);
            throw throwable;
        }
        this.safeClose((Closeable)client);
        this.checkResponse(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableDeployment(String deploymentName, boolean enabled) throws Exception {
        ModelControllerClient client = null;
        ModelNode response = null;
        try {
            client = this.createControllerClient();
            ModelNode operation = new ModelNode();
            if (enabled) {
                operation.get("operation").set("deploy");
            } else {
                operation.get("operation").set("undeploy");
            }
            operation.get("address").add("deployment", deploymentName);
            response = client.execute(operation);
        }
        catch (Throwable throwable) {
            this.safeClose((Closeable)client);
            this.checkResponse(response);
            throw throwable;
        }
        this.safeClose((Closeable)client);
        this.checkResponse(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDeployments() throws Exception {
        ModelControllerClient client = null;
        ArrayList<String> result = new ArrayList<String>();
        try {
            client = this.createControllerClient();
            ModelNode operation = new ModelNode();
            if (this.serverGroup != null) {
                operation.get("address").add("datasource.management.wildfly.serverGroup", this.serverGroup);
            }
            operation.get("address").add("deployment", "*");
            operation.get("operation").set("read-attribute");
            operation.get("name").set("name");
            ModelNode response = this.createControllerClient().execute(operation);
            if (!this.isFailure(response)) {
                if (response.hasDefined("result")) {
                    List nodes = response.get("result").asList();
                    for (ModelNode node : nodes) {
                        result.add(node.get("result").asString());
                    }
                }
            } else {
                this.checkResponse(response);
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        finally {
            this.safeClose((Closeable)client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDeployment(String deploymentName) throws Exception {
        ModelControllerClient client = null;
        ModelNode response = null;
        try {
            ModelNode operation;
            client = this.createControllerClient();
            if (this.serverGroup != null) {
                operation = new ModelNode();
                operation.get("operation").set("remove");
                operation.get("address").add("datasource.management.wildfly.serverGroup", this.serverGroup);
                operation.get("address").add("deployment", deploymentName);
                operation.get("name").set(deploymentName);
                response = client.execute(operation);
            }
            operation = new ModelNode();
            operation.get("operation").set("remove");
            operation.get("address").add("deployment", deploymentName);
            operation.get("name").set(deploymentName);
            response = client.execute(operation);
        }
        catch (Throwable throwable) {
            this.safeClose((Closeable)client);
            this.checkResponse(response);
            throw throwable;
        }
        this.safeClose((Closeable)client);
        this.checkResponse(response);
    }
}

