/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ks.integration;

import javax.inject.Inject;
import org.jbpm.workbench.ks.integration.KieServerIntegration;
import org.kie.server.client.KieServicesClient;

public abstract class AbstractKieServerService {
    @Inject
    protected KieServerIntegration kieServerIntegration;

    protected <T> T getClient(String serverTemplateId, Class<T> clientType) {
        KieServicesClient client = this.getKieServicesClient(serverTemplateId);
        return (T)client.getServicesClient(clientType);
    }

    protected <T> T getClient(String serverTemplateId, String containerId, Class<T> clientType) {
        KieServicesClient client = this.getKieServicesClient(serverTemplateId, containerId);
        return (T)client.getServicesClient(clientType);
    }

    protected KieServicesClient getKieServicesClient(String serverTemplateId, String containerId) {
        KieServicesClient client = this.kieServerIntegration.getServerClient(serverTemplateId, containerId);
        if (client == null) {
            throw new RuntimeException("No connection to '" + serverTemplateId + "' server(s). Server template configuration requires container '" + containerId + "' to be configured and started");
        }
        return client;
    }

    protected KieServicesClient getKieServicesClient(String serverTemplateId) {
        KieServicesClient client = this.kieServerIntegration.getServerClient(serverTemplateId);
        if (client == null) {
            throw new RuntimeException("No connection to '" + serverTemplateId + "' server(s)");
        }
        return client;
    }
}

