/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.backend.server;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.drools.workbench.models.datamodel.rule.ActionInsertFact;
import org.drools.workbench.models.datamodel.rule.CompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.CompositeFieldConstraint;
import org.drools.workbench.models.datamodel.rule.ConnectiveConstraint;
import org.drools.workbench.models.datamodel.rule.ExpressionFormLine;
import org.drools.workbench.models.datamodel.rule.ExpressionPart;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.FieldConstraint;
import org.drools.workbench.models.datamodel.rule.FromAccumulateCompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.FromCollectCompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.FromCompositeFactPattern;
import org.drools.workbench.models.datamodel.rule.IAction;
import org.drools.workbench.models.datamodel.rule.IFactPattern;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraint;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraintEBLeftSide;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.soup.project.datamodel.imports.Import;
import org.kie.soup.project.datamodel.imports.Imports;

public class GuidedRuleModelVisitor {
    private final RuleModel model;
    private final String packageName;
    private final Imports imports;

    public GuidedRuleModelVisitor(RuleModel model) {
        this.model = (RuleModel)PortablePreconditions.checkNotNull((String)"model", (Object)model);
        this.packageName = model.getPackageName();
        this.imports = model.getImports();
    }

    public Set<String> getConsumedModelClasses() {
        int i;
        HashSet<String> factTypes = new HashSet<String>();
        if (this.model.lhs != null) {
            for (i = 0; i < this.model.lhs.length; ++i) {
                IPattern pattern = this.model.lhs[i];
                factTypes.addAll(this.visit(pattern));
            }
        }
        if (this.model.rhs != null) {
            for (i = 0; i < this.model.rhs.length; ++i) {
                IAction action = this.model.rhs[i];
                factTypes.addAll(this.visit(action));
            }
        }
        HashSet<String> fullyQualifiedClassNames = new HashSet<String>();
        for (String factType : factTypes) {
            fullyQualifiedClassNames.add(this.convertToFullyQualifiedClassName(factType));
        }
        return fullyQualifiedClassNames;
    }

    private String convertToFullyQualifiedClassName(String factType) {
        if (factType.contains(".")) {
            return factType;
        }
        String fullyQualifiedClassName = null;
        for (Import imp : this.imports.getImports()) {
            if (!imp.getType().endsWith(factType)) continue;
            fullyQualifiedClassName = imp.getType();
            break;
        }
        if (fullyQualifiedClassName == null) {
            fullyQualifiedClassName = this.packageName + "." + factType;
        }
        return fullyQualifiedClassName;
    }

    private Set<String> visit(Object o) {
        if (o == null) {
            return Collections.EMPTY_SET;
        }
        if (o instanceof FactPattern) {
            return this.visitFactPattern((FactPattern)o);
        }
        if (o instanceof CompositeFieldConstraint) {
            return this.visitCompositeFieldConstraint((CompositeFieldConstraint)o);
        }
        if (o instanceof SingleFieldConstraintEBLeftSide) {
            return this.visitSingleFieldConstraint((SingleFieldConstraintEBLeftSide)o);
        }
        if (o instanceof SingleFieldConstraint) {
            return this.visitSingleFieldConstraint((SingleFieldConstraint)o);
        }
        if (o instanceof ExpressionFormLine) {
            return this.visitExpressionFormLine((ExpressionFormLine)o);
        }
        if (o instanceof ConnectiveConstraint) {
            return this.visitConnectiveConstraint((ConnectiveConstraint)o);
        }
        if (o instanceof CompositeFactPattern) {
            return this.visitCompositeFactPattern((CompositeFactPattern)o);
        }
        if (o instanceof FromAccumulateCompositeFactPattern) {
            return this.visitFromAccumulateCompositeFactPattern((FromAccumulateCompositeFactPattern)o);
        }
        if (o instanceof FromCollectCompositeFactPattern) {
            return this.visitFromCollectCompositeFactPattern((FromCollectCompositeFactPattern)o);
        }
        if (o instanceof FromCompositeFactPattern) {
            return this.visitFromCompositeFactPattern((FromCompositeFactPattern)o);
        }
        if (o instanceof ActionInsertFact) {
            return this.visitActionInsertFact((ActionInsertFact)o);
        }
        return Collections.EMPTY_SET;
    }

    private Set<String> visitActionInsertFact(ActionInsertFact afl) {
        HashSet<String> factTypes = new HashSet<String>();
        factTypes.add(afl.getFactType());
        return factTypes;
    }

    private Set<String> visitCompositeFactPattern(CompositeFactPattern pattern) {
        HashSet<String> factTypes = new HashSet<String>();
        if (pattern.getPatterns() != null) {
            for (IFactPattern fp : pattern.getPatterns()) {
                factTypes.addAll(this.visit(fp));
            }
        }
        return factTypes;
    }

    private Set<String> visitCompositeFieldConstraint(CompositeFieldConstraint cfc) {
        HashSet<String> factTypes = new HashSet<String>();
        if (cfc.getConstraints() != null) {
            for (int i = 0; i < cfc.getConstraints().length; ++i) {
                FieldConstraint fc = cfc.getConstraints()[i];
                factTypes.addAll(this.visit(fc));
            }
        }
        return factTypes;
    }

    private Set<String> visitFactPattern(FactPattern pattern) {
        HashSet<String> factTypes = new HashSet<String>();
        factTypes.add(pattern.getFactType());
        for (FieldConstraint fc : pattern.getFieldConstraints()) {
            factTypes.addAll(this.visit(fc));
        }
        return factTypes;
    }

    private Set<String> visitFromAccumulateCompositeFactPattern(FromAccumulateCompositeFactPattern pattern) {
        HashSet<String> factTypes = new HashSet<String>();
        factTypes.addAll(this.visit(pattern.getFactPattern()));
        factTypes.addAll(this.visit(pattern.getSourcePattern()));
        return factTypes;
    }

    private Set<String> visitFromCollectCompositeFactPattern(FromCollectCompositeFactPattern pattern) {
        HashSet<String> factTypes = new HashSet<String>();
        factTypes.addAll(this.visit(pattern.getFactPattern()));
        factTypes.addAll(this.visit(pattern.getRightPattern()));
        factTypes.addAll(this.visit(pattern.getExpression()));
        return factTypes;
    }

    private Set<String> visitFromCompositeFactPattern(FromCompositeFactPattern pattern) {
        HashSet<String> factTypes = new HashSet<String>();
        factTypes.addAll(this.visit(pattern.getFactPattern()));
        factTypes.addAll(this.visit(pattern.getExpression()));
        return factTypes;
    }

    private Set<String> visitSingleFieldConstraint(SingleFieldConstraint sfc) {
        HashSet<String> factTypes = new HashSet<String>();
        if (sfc.getFactType() != null) {
            factTypes.add(sfc.getFactType());
        }
        factTypes.addAll(this.visit(sfc.getExpressionValue()));
        if (sfc.getConnectives() != null) {
            for (int i = 0; i < sfc.getConnectives().length; ++i) {
                factTypes.addAll(this.visit(sfc.getConnectives()[i]));
            }
        }
        return factTypes;
    }

    private Set<String> visitExpressionFormLine(ExpressionFormLine efl) {
        HashSet<String> factTypes = new HashSet<String>();
        for (ExpressionPart part : efl.getParts()) {
            if (part.getClassType() == null) continue;
            factTypes.add(part.getClassType());
        }
        return factTypes;
    }

    private Set<String> visitConnectiveConstraint(ConnectiveConstraint cc) {
        HashSet<String> factTypes = new HashSet<String>();
        if (cc.getFactType() != null) {
            factTypes.add(cc.getFactType());
        }
        return factTypes;
    }

    private Set<String> visitSingleFieldConstraint(SingleFieldConstraintEBLeftSide sfexp) {
        HashSet<String> factTypes = new HashSet<String>();
        if (sfexp.getFactType() != null) {
            factTypes.add(sfexp.getFactType());
        }
        factTypes.addAll(this.visit(sfexp.getExpressionValue()));
        factTypes.addAll(this.visit(sfexp.getExpressionLeftSide()));
        if (sfexp.getConnectives() != null) {
            for (int i = 0; i < sfexp.getConnectives().length; ++i) {
                factTypes.addAll(this.visit(sfexp.getConnectives()[i]));
            }
        }
        return factTypes;
    }
}

