/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.command.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.SetChildrenCommand;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Parent;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;

@Portable
public class RemoveChildrenCommand
extends AbstractGraphCommand {
    private final String parentUUID;
    private final String[] candidateUUIDs;
    private transient Node<?, Edge> parent;
    private transient Collection<Node<?, Edge>> candidates;

    public RemoveChildrenCommand(@MapsTo(value="parentUUID") String parentUUID, @MapsTo(value="candidateUUIDs") String[] candidateUUIDs) {
        this.parentUUID = (String)PortablePreconditions.checkNotNull((String)"parentUUID", (Object)parentUUID);
        this.candidateUUIDs = (String[])PortablePreconditions.checkNotNull((String)"candidateUUIDs", (Object)candidateUUIDs);
    }

    public RemoveChildrenCommand(Node<?, Edge> parent, Node<?, Edge> candidate) {
        this(parent.getUUID(), new String[]{candidate.getUUID()});
        this.parent = parent;
        this.candidates = Collections.singleton(candidate);
    }

    public RemoveChildrenCommand(Node<?, Edge> parent, Collection<Node<?, Edge>> candidates) {
        this(parent.getUUID(), CommandUtils.toUUIDs(candidates));
        this.parent = parent;
        this.candidates = candidates;
    }

    public CommandResult<RuleViolation> execute(GraphCommandExecutionContext context) {
        CommandResult<RuleViolation> results = this.allow(context);
        if (!results.getType().equals((Object)CommandResult.Type.ERROR)) {
            Node<?, Edge> parent = this.getParent(context);
            this.getCandidates(context).forEach(candidate -> this.removeChild(context, parent, (Node<?, Edge>)candidate));
        }
        return results;
    }

    private void removeChild(GraphCommandExecutionContext context, Node<?, Edge> parent, Node<?, Edge> candidate) {
        Edge<Parent, Node> edge = this.getEdgeForTarget(parent, candidate);
        if (null != edge) {
            edge.setSourceNode(null);
            edge.setTargetNode(null);
            parent.getOutEdges().remove(edge);
            candidate.getInEdges().remove(edge);
            this.getMutableIndex(context).removeEdge(edge);
        }
    }

    private Edge<Parent, Node> getEdgeForTarget(Node<?, Edge> parent, Node<?, Edge> candidate) {
        List outEdges = parent.getOutEdges();
        if (null != outEdges && !outEdges.isEmpty()) {
            for (Edge outEdge : outEdges) {
                Node targetNode;
                if (!(outEdge.getContent() instanceof Child) || null == (targetNode = outEdge.getTargetNode()) || !targetNode.equals(candidate)) continue;
                return outEdge;
            }
        }
        return null;
    }

    @Override
    protected CommandResult<RuleViolation> check(GraphCommandExecutionContext context) {
        this.getParent(context);
        return GraphCommandResultBuilder.SUCCESS;
    }

    public CommandResult<RuleViolation> undo(GraphCommandExecutionContext context) {
        SetChildrenCommand undoCommand = new SetChildrenCommand(this.getParent(context), this.getCandidates(context));
        return undoCommand.execute(context);
    }

    protected Node<?, Edge> getParent(GraphCommandExecutionContext context) {
        if (null == this.parent) {
            this.parent = this.getNodeNotNull(context, this.parentUUID);
        }
        return this.parent;
    }

    protected Collection<Node<?, Edge>> getCandidates(GraphCommandExecutionContext context) {
        if (null == this.candidates) {
            this.candidates = CommandUtils.getCandidates((GraphCommandExecutionContext)context, (String[])this.candidateUUIDs);
        }
        return this.candidates;
    }

    public Node<?, Edge> getParent() {
        return this.parent;
    }

    public Collection<Node<?, Edge>> getCandidates() {
        return this.candidates;
    }

    public String toString() {
        return "RemoveChildCommand [parent=" + this.parentUUID + ", candidates=" + this.candidateUUIDs + "]";
    }
}

