/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.command.impl;

import java.util.Collection;
import java.util.Collections;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.RemoveChildrenCommand;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.impl.EdgeImpl;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.util.UUID;

@Portable
public class SetChildrenCommand
extends AbstractGraphCommand {
    private final String parentUUID;
    private final String[] candidateUUIDs;
    private transient Node<?, Edge> parent;
    private transient Collection<Node<?, Edge>> candidates;

    public SetChildrenCommand(@MapsTo(value="parentUUID") String parentUUID, @MapsTo(value="candidateUUIDs") String[] candidateUUIDs) {
        this.parentUUID = (String)PortablePreconditions.checkNotNull((String)"parentUUID", (Object)parentUUID);
        this.candidateUUIDs = (String[])PortablePreconditions.checkNotNull((String)"candidateUUIDs", (Object)candidateUUIDs);
    }

    public SetChildrenCommand(Node<?, Edge> parent, Node<?, Edge> candidate) {
        this(parent.getUUID(), new String[]{candidate.getUUID()});
        this.parent = parent;
        this.candidates = Collections.singleton(candidate);
    }

    public SetChildrenCommand(Node<?, Edge> parent, Collection<Node<?, Edge>> candidates) {
        this(parent.getUUID(), CommandUtils.toUUIDs(candidates));
        this.parent = parent;
        this.candidates = candidates;
    }

    public CommandResult<RuleViolation> execute(GraphCommandExecutionContext context) {
        CommandResult<RuleViolation> results = this.allow(context);
        if (!results.getType().equals((Object)CommandResult.Type.ERROR)) {
            this.getCandidates(context).forEach(node -> this.execute(context, this.getParent(context), (Node<?, Edge>)node));
        }
        return results;
    }

    protected void execute(GraphCommandExecutionContext context, Node<?, Edge> parent, Node<?, Edge> candidate) {
        String uuid = UUID.uuid();
        EdgeImpl edge = new EdgeImpl(uuid);
        edge.setContent(new Child());
        edge.setSourceNode(parent);
        edge.setTargetNode(candidate);
        parent.getOutEdges().add(edge);
        candidate.getInEdges().add(edge);
        this.getMutableIndex(context).addEdge(edge);
    }

    @Override
    protected CommandResult<RuleViolation> check(GraphCommandExecutionContext context) {
        Node<?, Edge> parent = this.getParent(context);
        Collection<Node<?, Edge>> candidates = this.getCandidates(context);
        Collection<RuleViolation> containmentRuleViolations = this.evaluate(context, contextBuilder -> contextBuilder.containment((Element<? extends Definition<?>>)parent, (Collection<Node<? extends Definition<?>, ? extends Edge>>)candidates));
        return new GraphCommandResultBuilder(containmentRuleViolations).build();
    }

    public CommandResult<RuleViolation> undo(GraphCommandExecutionContext context) {
        Node<?, Edge> parent = this.getParent(context);
        Collection<Node<?, Edge>> candidates = this.getCandidates(context);
        RemoveChildrenCommand undoCommand = new RemoveChildrenCommand(parent, candidates);
        return undoCommand.execute(context);
    }

    public Node<?, Edge> getParent() {
        return this.parent;
    }

    public Collection<Node<?, Edge>> getCandidates() {
        return this.candidates;
    }

    protected Node<?, Edge> getParent(GraphCommandExecutionContext context) {
        if (null == this.parent) {
            this.parent = this.getNodeNotNull(context, this.parentUUID);
        }
        return this.parent;
    }

    protected Collection<Node<?, Edge>> getCandidates(GraphCommandExecutionContext context) {
        if (null == this.candidates) {
            this.candidates = CommandUtils.getCandidates((GraphCommandExecutionContext)context, (String[])this.candidateUUIDs);
        }
        return this.candidates;
    }

    public String toString() {
        return "AddChildEdgeCommand [parent=" + this.parentUUID + ", candidates=" + this.candidateUUIDs + "]";
    }
}

