/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.math.big;

import ch.obermuhlner.math.big.BigDecimalMath;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Objects;

public final class BigComplex {
    public static final BigComplex ZERO = new BigComplex(BigDecimal.ZERO, BigDecimal.ZERO);
    public static final BigComplex ONE = new BigComplex(BigDecimal.ONE, BigDecimal.ZERO);
    public static final BigComplex I = new BigComplex(BigDecimal.ZERO, BigDecimal.ONE);
    public final BigDecimal re;
    public final BigDecimal im;

    private BigComplex(BigDecimal re, BigDecimal im) {
        this.re = re;
        this.im = im;
    }

    public BigComplex add(BigComplex value) {
        return BigComplex.valueOf(this.re.add(value.re), this.im.add(value.im));
    }

    public BigComplex add(BigComplex value, MathContext mathContext) {
        return BigComplex.valueOf(this.re.add(value.re, mathContext), this.im.add(value.im, mathContext));
    }

    public BigComplex add(BigDecimal value, MathContext mathContext) {
        return BigComplex.valueOf(this.re.add(value, mathContext), this.im);
    }

    public BigComplex add(BigDecimal value) {
        return BigComplex.valueOf(this.re.add(value), this.im);
    }

    public BigComplex add(double value) {
        return this.add(BigDecimal.valueOf(value));
    }

    public BigComplex subtract(BigComplex value) {
        return BigComplex.valueOf(this.re.subtract(value.re), this.im.subtract(value.im));
    }

    public BigComplex subtract(BigComplex value, MathContext mathContext) {
        return BigComplex.valueOf(this.re.subtract(value.re, mathContext), this.im.subtract(value.im, mathContext));
    }

    public BigComplex subtract(BigDecimal value, MathContext mathContext) {
        return BigComplex.valueOf(this.re.subtract(value, mathContext), this.im);
    }

    public BigComplex subtract(BigDecimal value) {
        return BigComplex.valueOf(this.re.subtract(value), this.im);
    }

    public BigComplex subtract(double value) {
        return this.subtract(BigDecimal.valueOf(value));
    }

    public BigComplex multiply(BigComplex value) {
        return BigComplex.valueOf(this.re.multiply(value.re).subtract(this.im.multiply(value.im)), this.re.multiply(value.im).add(this.im.multiply(value.re)));
    }

    public BigComplex multiply(BigComplex value, MathContext mathContext) {
        return BigComplex.valueOf(this.re.multiply(value.re, mathContext).subtract(this.im.multiply(value.im, mathContext), mathContext), this.re.multiply(value.im, mathContext).add(this.im.multiply(value.re, mathContext), mathContext));
    }

    public BigComplex multiply(BigDecimal value, MathContext mathContext) {
        return BigComplex.valueOf(this.re.multiply(value, mathContext), this.im.multiply(value, mathContext));
    }

    public BigComplex multiply(BigDecimal value) {
        return BigComplex.valueOf(this.re.multiply(value), this.im.multiply(value));
    }

    public BigComplex multiply(double value) {
        return this.multiply(BigDecimal.valueOf(value));
    }

    public BigComplex divide(BigComplex value, MathContext mathContext) {
        return this.multiply(value.reciprocal(mathContext), mathContext);
    }

    public BigComplex divide(BigDecimal value, MathContext mathContext) {
        return BigComplex.valueOf(this.re.divide(value, mathContext), this.im.divide(value, mathContext));
    }

    public BigComplex divide(double value, MathContext mathContext) {
        return this.divide(BigDecimal.valueOf(value), mathContext);
    }

    public BigComplex reciprocal(MathContext mathContext) {
        BigDecimal scale = this.absSquare(mathContext);
        return BigComplex.valueOf(this.re.divide(scale, mathContext), this.im.negate().divide(scale, mathContext));
    }

    public BigComplex conjugate() {
        return BigComplex.valueOf(this.re, this.im.negate());
    }

    public BigComplex negate() {
        return BigComplex.valueOf(this.re.negate(), this.im.negate());
    }

    public BigDecimal abs(MathContext mathContext) {
        return BigDecimalMath.sqrt(this.absSquare(mathContext), mathContext);
    }

    public BigDecimal angle(MathContext mathContext) {
        return BigDecimalMath.atan2(this.im, this.re, mathContext);
    }

    public BigDecimal absSquare(MathContext mathContext) {
        return this.re.multiply(this.re, mathContext).add(this.im.multiply(this.im, mathContext), mathContext);
    }

    public boolean isReal() {
        return this.im.signum() == 0;
    }

    public BigComplex re() {
        return BigComplex.valueOf(this.re, BigDecimal.ZERO);
    }

    public BigComplex im() {
        return BigComplex.valueOf(BigDecimal.ZERO, this.im);
    }

    public BigComplex round(MathContext mathContext) {
        return BigComplex.valueOf(this.re.round(mathContext), this.im.round(mathContext));
    }

    public int hashCode() {
        return Objects.hash(this.re, this.im);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BigComplex other = (BigComplex)obj;
        return this.re.compareTo(other.re) == 0 && this.im.compareTo(other.im) == 0;
    }

    public boolean strictEquals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BigComplex other = (BigComplex)obj;
        return this.re.equals(other.re) && this.im.equals(other.im);
    }

    public String toString() {
        if (this.im.signum() >= 0) {
            return "(" + this.re + " + " + this.im + " i)";
        }
        return "(" + this.re + " - " + this.im.negate() + " i)";
    }

    public static BigComplex valueOf(BigDecimal real) {
        return BigComplex.valueOf(real, BigDecimal.ZERO);
    }

    public static BigComplex valueOf(double real) {
        return BigComplex.valueOf(BigDecimal.valueOf(real), BigDecimal.ZERO);
    }

    public static BigComplex valueOf(double real, double imaginary) {
        return BigComplex.valueOf(BigDecimal.valueOf(real), BigDecimal.valueOf(imaginary));
    }

    public static BigComplex valueOf(BigDecimal real, BigDecimal imaginary) {
        if (real.signum() == 0) {
            if (imaginary.signum() == 0) {
                return ZERO;
            }
            if (imaginary.compareTo(BigDecimal.ONE) == 0) {
                return I;
            }
        }
        if (imaginary.signum() == 0 && real.compareTo(BigDecimal.ONE) == 0) {
            return ONE;
        }
        return new BigComplex(real, imaginary);
    }

    public static BigComplex valueOfPolar(BigDecimal radius, BigDecimal angle, MathContext mathContext) {
        if (radius.signum() == 0) {
            return ZERO;
        }
        return BigComplex.valueOf(radius.multiply(BigDecimalMath.cos(angle, mathContext), mathContext), radius.multiply(BigDecimalMath.sin(angle, mathContext), mathContext));
    }

    public static BigComplex valueOfPolar(double radius, double angle, MathContext mathContext) {
        return BigComplex.valueOfPolar(BigDecimal.valueOf(radius), BigDecimal.valueOf(angle), mathContext);
    }
}

