/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.workbench.client.docks;

import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.widgets.client.docks.AuthoringEditorDock;
import org.kie.workbench.common.widgets.client.docks.WorkbenchDocksHandler;
import org.kie.workbench.common.workbench.client.events.LayoutEditorFocusEvent;
import org.kie.workbench.common.workbench.client.resources.i18n.DefaultWorkbenchConstants;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.client.workbench.docks.UberfireDockReadyEvent;
import org.uberfire.client.workbench.docks.UberfireDocks;
import org.uberfire.client.workbench.events.PlaceHiddenEvent;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@ApplicationScoped
public class AuthoringWorkbenchDocks
implements AuthoringEditorDock {
    protected DefaultWorkbenchConstants constants = DefaultWorkbenchConstants.INSTANCE;
    protected UberfireDocks uberfireDocks;
    protected String authoringPerspectiveIdentifier = null;
    protected UberfireDock projectExplorerDock;
    protected UberfireDock componentPaletteDock;
    protected String currentPerspectiveIdentifier = null;
    protected boolean projectExplorerEnabled = true;
    protected boolean componentPaletteEnabled = false;
    protected ManagedInstance<WorkbenchDocksHandler> installedHandlers;
    protected WorkbenchDocksHandler activeHandler = null;
    protected UberfireDock[] activeDocks;

    @Inject
    public AuthoringWorkbenchDocks(UberfireDocks uberfireDocks, ManagedInstance<WorkbenchDocksHandler> installedHandlers) {
        this.uberfireDocks = uberfireDocks;
        this.installedHandlers = installedHandlers;
    }

    @PostConstruct
    public void initialize() {
        this.installedHandlers.iterator().forEachRemaining(handler -> handler.init(() -> this.setActiveHandler((WorkbenchDocksHandler)handler)));
    }

    public boolean isSetup() {
        return this.authoringPerspectiveIdentifier != null;
    }

    public void perspectiveChangeEvent(@Observes UberfireDockReadyEvent dockReadyEvent) {
        this.currentPerspectiveIdentifier = dockReadyEvent.getCurrentPerspective();
        if (this.authoringPerspectiveIdentifier != null && dockReadyEvent.getCurrentPerspective().equals(this.authoringPerspectiveIdentifier) && this.projectExplorerEnabled) {
            this.expandProjectExplorer();
        }
    }

    public void setup(String authoringPerspectiveIdentifier, PlaceRequest projectExplorerPlaceRequest) {
        this.authoringPerspectiveIdentifier = authoringPerspectiveIdentifier;
        this.projectExplorerDock = new UberfireDock(UberfireDockPosition.WEST, IconType.FOLDER_OPEN.toString(), projectExplorerPlaceRequest, authoringPerspectiveIdentifier).withSize(400.0).withLabel(this.constants.DocksProjectExplorerTitle());
        this.componentPaletteDock = new UberfireDock(UberfireDockPosition.WEST, IconType.CUBES.toString(), (PlaceRequest)new DefaultPlaceRequest("LavoutComponentPaletteScreen"), authoringPerspectiveIdentifier).withSize(400.0).withLabel(this.constants.LayoutEditorComponentPalette());
        this.uberfireDocks.add(new UberfireDock[]{this.projectExplorerDock});
        this.uberfireDocks.hide(UberfireDockPosition.EAST, authoringPerspectiveIdentifier);
    }

    public void setActiveHandler(WorkbenchDocksHandler handler) {
        if (this.activeHandler != null && this.activeHandler.equals(handler) && !this.activeHandler.shouldRefreshDocks()) {
            return;
        }
        this.activeHandler = handler;
        if (this.activeHandler.shouldDisableDocks()) {
            this.uberfireDocks.hide(UberfireDockPosition.EAST, this.currentPerspectiveIdentifier);
        } else {
            if (this.activeDocks != null) {
                this.uberfireDocks.remove(this.activeDocks);
            }
            Collection docks = this.activeHandler.provideDocks(this.currentPerspectiveIdentifier);
            this.activeDocks = docks.toArray(new UberfireDock[docks.size()]);
            this.uberfireDocks.add(this.activeDocks);
            this.uberfireDocks.show(UberfireDockPosition.EAST, this.currentPerspectiveIdentifier);
        }
    }

    public boolean isAuthoringActive() {
        return this.authoringPerspectiveIdentifier != null && this.authoringPerspectiveIdentifier.equals(this.currentPerspectiveIdentifier);
    }

    public void hide() {
        if (this.componentPaletteEnabled) {
            this.uberfireDocks.remove(new UberfireDock[]{this.componentPaletteDock});
            this.componentPaletteEnabled = false;
        }
        this.uberfireDocks.hide(UberfireDockPosition.WEST, this.authoringPerspectiveIdentifier);
        this.projectExplorerEnabled = false;
    }

    public void show() {
        this.uberfireDocks.show(UberfireDockPosition.WEST, this.authoringPerspectiveIdentifier);
        this.projectExplorerEnabled = true;
    }

    public void expandProjectExplorer() {
        if (this.projectExplorerDock != null && !this.componentPaletteEnabled) {
            this.uberfireDocks.open(this.projectExplorerDock);
        }
    }

    public void expandAuthoringDock(UberfireDock dockToOpen) {
        this.uberfireDocks.show(UberfireDockPosition.EAST, this.authoringPerspectiveIdentifier);
        if (dockToOpen != null) {
            this.uberfireDocks.open(dockToOpen);
        }
    }

    private void refreshWestDocks(boolean showComponentPalette, UberfireDock dockToOpen) {
        if (showComponentPalette && !this.componentPaletteEnabled) {
            this.uberfireDocks.add(new UberfireDock[]{this.componentPaletteDock});
            this.componentPaletteEnabled = true;
        }
        if (!showComponentPalette && this.componentPaletteEnabled) {
            this.uberfireDocks.remove(new UberfireDock[]{this.componentPaletteDock});
            this.componentPaletteEnabled = false;
        }
        this.uberfireDocks.show(UberfireDockPosition.WEST, this.authoringPerspectiveIdentifier);
        if (dockToOpen != null) {
            this.uberfireDocks.open(dockToOpen);
        }
    }

    public void onLayoutEditorFocus(@Observes LayoutEditorFocusEvent event) {
        this.refreshWestDocks(true, this.componentPaletteDock);
    }

    public void onLayoutEditorClose(@Observes PlaceHiddenEvent event) {
        String placeId = event.getPlace().getIdentifier();
        if ("FormEditor".equals(placeId)) {
            this.refreshWestDocks(false, null);
        }
    }

    @PreDestroy
    public void clear() {
        this.activeDocks = null;
        this.activeHandler = null;
        this.installedHandlers.destroyAll();
    }
}

