/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.prometheus.client;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Base64;

public class HttpClient {
    private static HttpClient INSTANCE;

    private HttpClient() {
    }

    public String doGet(String url) {
        return this.doGet(url, null, null);
    }

    public String doGet(String url, String username, String password) {
        String string;
        URLConnection connection = new URL(url).openConnection();
        if (username != null && !username.trim().isEmpty()) {
            this.addAuth(connection, username, password);
        }
        InputStreamReader in = new InputStreamReader(connection.getInputStream());
        BufferedReader br = new BufferedReader(in);
        try {
            string = br.readLine();
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("Error performing HTTP Request: " + e.getMessage(), e);
            }
        }
        br.close();
        return string;
    }

    private void addAuth(URLConnection connection, String username, String password) {
        String userpass = username + ":" + password;
        String basicAuth = "Basic " + new String(Base64.getEncoder().encode(userpass.getBytes()));
        connection.setRequestProperty("Authorization", basicAuth);
    }

    public static HttpClient get() {
        if (INSTANCE == null) {
            INSTANCE = new HttpClient();
        }
        return INSTANCE;
    }
}

